/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.IntermediateOutputStream;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.WriteConvertor;
import org.apache.tomcat.util.res.StringManager;

public final class C2BConverter {
    private static final Log log = LogFactory.getLog(C2BConverter.class);
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.buf");
    private final String encoding;
    private BufferedWriter writer;
    private WriteConvertor conv;
    private IntermediateOutputStream ios;
    private ByteChunk bb;

    public C2BConverter(ByteChunk output, String encoding) throws IOException {
        this.bb = output;
        this.encoding = encoding;
        this.init();
    }

    @Deprecated
    public C2BConverter(String encoding) throws IOException {
        this(new ByteChunk(1024), encoding);
    }

    @Deprecated
    public ByteChunk getByteChunk() {
        return this.bb;
    }

    @Deprecated
    public String getEncoding() {
        return this.encoding;
    }

    @Deprecated
    public void setByteChunk(ByteChunk bb) {
        this.bb = bb;
        this.ios.setByteChunk(bb);
    }

    public final void recycle() {
        this.ios.disable();
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            log.warn(sm.getString("c2bConverter.recycleFailed"), e);
            try {
                this.init();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ios.enable();
        this.bb.recycle();
    }

    private void init() throws IOException {
        this.ios = new IntermediateOutputStream(this.bb);
        this.conv = new WriteConvertor(this.ios, B2CConverter.getCharset(this.encoding));
        this.writer = new BufferedWriter(this.conv);
    }

    public final void convert(char[] c, int off, int len) throws IOException {
        this.writer.write(c, off, len);
    }

    public final void convert(String s, int off, int len) throws IOException {
        this.writer.write(s, off, len);
    }

    public final void convert(String s) throws IOException {
        this.writer.write(s);
    }

    public final void convert(char c) throws IOException {
        this.writer.write(c);
    }

    @Deprecated
    public final void convert(MessageBytes mb) throws IOException {
        int type = mb.getType();
        if (type == 2) {
            return;
        }
        ByteChunk orig = this.bb;
        this.setByteChunk(mb.getByteChunk());
        this.bb.recycle();
        this.bb.allocate(32, -1);
        if (type == 1) {
            this.convert(mb.getString());
        } else if (type == 3) {
            CharChunk charC = mb.getCharChunk();
            this.convert(charC.getBuffer(), charC.getOffset(), charC.getLength());
        } else if (log.isDebugEnabled()) {
            log.debug("XXX unknowon type " + type);
        }
        this.flushBuffer();
        this.setByteChunk(orig);
    }

    public final void flushBuffer() throws IOException {
        this.writer.flush();
    }
}

