/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.domain.money.Money;
import org.crazyyak.dev.domain.translation.jackson.MoneyDeserializer;
import org.crazyyak.dev.domain.translation.jackson.MoneySerializer;

public class YakModule
extends SimpleModule {
    public YakModule() {
        this.addSerializer(new MoneySerializer());
        this.addDeserializer(Money.class, new MoneyDeserializer());
        this.addSerializer(new StdSerializer<String>(String.class){

            @Override
            public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                if (StringUtils.isBlank(value)) {
                    jgen.writeNull();
                } else {
                    jgen.writeString(value);
                }
            }
        });
    }
}

