/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.embedded;

import java.io.File;
import java.util.Arrays;
import org.crazyyak.dev.common.StringUtils;

public class EmbeddedArgs {
    private final String webAppRoot;
    private String contextPath = "";
    private String workingDirectory;
    private int shutDownPort = 8005;
    private int httpPort = 8080;
    private int securePort;
    private int ajpHttpPort;
    private int ajpSecurePort;
    private String keystoreFile;
    private String keystorePass;
    private String truststoreFile;
    private String truststorePass;
    private String keyAlias;
    private boolean autoShutDown;

    public EmbeddedArgs(String ... args) {
        if (args.length % 2 != 0) {
            String msg = String.format("Expected an even number of arguments, not %s: %s", args.length, Arrays.asList(args));
            throw new IllegalArgumentException(msg);
        }
        String webAppRoot = null;
        for (int i = 0; i < args.length; i += 2) {
            String key = args[i];
            String value = args[i + 1];
            if ("webAppRoot".equals(key)) {
                webAppRoot = value;
                continue;
            }
            this.parseArgs(key, value);
        }
        this.webAppRoot = webAppRoot;
    }

    public String getErrorMessage() {
        if (StringUtils.isBlank(this.webAppRoot)) {
            return "The argument webAppRoot must be specified.";
        }
        if (StringUtils.isBlank(this.workingDirectory)) {
            return "The argument workingDirectory must be specified.";
        }
        return null;
    }

    public static void printUsage() {
        System.out.println("Arguments: webAppRoot \"{path}\"");
        System.out.println("           [contextPath \"{path}\"]");
        System.out.println("           workingDirectory \"{path}\"");
        System.out.println("           autoShutDown boolean (default false)");
        System.out.println("           shutDownPort int (default 8005)");
        System.out.println("           [httpPort int (default 8080)]");
        System.out.println("           [securePort int]");
        System.out.println("           [ajpHttpPort int]");
        System.out.println("           [ajpSecurePort int]");
        System.out.println("           [keystoreFile \"{path}\" keystorePass string]");
        System.out.println("           [truststoreFile \"{path}\" truststorePass string]");
        System.out.println("           [keyAlias string]");
    }

    private Object parseArgs(String key, String value) {
        try {
            switch (key) {
                case "contextPath": {
                    this.contextPath = value;
                    return this.contextPath;
                }
                case "workingDirectory": {
                    this.workingDirectory = value;
                    return this.workingDirectory;
                }
                case "shutDownPort": {
                    this.shutDownPort = Integer.valueOf(value);
                    return this.shutDownPort;
                }
                case "httpPort": {
                    this.httpPort = Integer.valueOf(value);
                    return this.httpPort;
                }
                case "securePort": {
                    this.securePort = Integer.valueOf(value);
                    return this.securePort;
                }
                case "ajpHttpPort": {
                    this.ajpHttpPort = Integer.valueOf(value);
                    return this.ajpHttpPort;
                }
                case "ajpSecurePort": {
                    this.ajpSecurePort = Integer.valueOf(value);
                    return this.ajpSecurePort;
                }
                case "keystoreFile": {
                    this.keystoreFile = value;
                    return this.keystoreFile;
                }
                case "keystorePass": {
                    this.keystorePass = value;
                    return this.keystorePass;
                }
                case "truststoreFile": {
                    this.truststoreFile = value;
                    return this.truststoreFile;
                }
                case "truststorePass": {
                    this.truststorePass = value;
                    return this.truststorePass;
                }
                case "keyAlias": {
                    this.keyAlias = value;
                    return this.keyAlias;
                }
                case "autoShutDown": {
                    this.autoShutDown = Boolean.valueOf(value);
                    return this.autoShutDown;
                }
            }
            String msg = String.format("", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Unable to parse the number \"%s\" for the argument \"%s\".", value, key);
            throw new IllegalArgumentException(msg);
        }
    }

    public EmbeddedArgs(String webAppRoot) {
        this.webAppRoot = webAppRoot;
    }

    public EmbeddedArgs(File webAppRoot) {
        this.webAppRoot = webAppRoot.getAbsolutePath();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getWebAppRoot() {
        return this.webAppRoot;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory.getAbsolutePath();
    }

    public int getShutDownPort() {
        return this.shutDownPort;
    }

    public void setShutDownPort(int shutDownPort) {
        this.shutDownPort = shutDownPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public void setSecurePort(int securePort) {
        this.securePort = securePort;
    }

    public int getAjpHttpPort() {
        return this.ajpHttpPort;
    }

    public void setAjpHttpPort(int ajpHttpPort) {
        this.ajpHttpPort = ajpHttpPort;
    }

    public int getAjpSecurePort() {
        return this.ajpSecurePort;
    }

    public void setAjpSecurePort(int ajpSecurePort) {
        this.ajpSecurePort = ajpSecurePort;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststoreFile(String truststoreFile) {
        this.truststoreFile = truststoreFile;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public void setTruststorePass(String truststorePass) {
        this.truststorePass = truststorePass;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public boolean isAutoShutDown() {
        return this.autoShutDown;
    }

    public void setAutoShutDown(boolean autoShutDown) {
        this.autoShutDown = autoShutDown;
    }
}

