/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.embedded;

import java.io.OutputStream;
import java.net.Socket;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.ajp.AjpNioProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.embedded.EmbeddedArgs;
import org.crazyyak.dev.embedded.EmbeddedStatus;

public class EmbeddedTomcat {
    private final int httpPort;
    private final int shutdownPort;
    private final String contextPath;
    private final String webAppRoot;
    private final Tomcat tomcat = new Tomcat();

    public static void main(String ... args) {
        try {
            EmbeddedArgs embeddedArgs = new EmbeddedArgs(args);
            if (embeddedArgs.getErrorMessage() != null) {
                System.out.println(embeddedArgs.getErrorMessage());
                embeddedArgs.printUsage();
                System.out.flush();
                return;
            }
            EmbeddedTomcat embedded = new EmbeddedTomcat(embeddedArgs);
            embedded.start(true, embeddedArgs.isAutoShutDown());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            EmbeddedArgs.printUsage();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public EmbeddedTomcat(EmbeddedArgs args) throws Exception {
        Connector connector;
        if (args.getErrorMessage() != null) {
            throw new IllegalArgumentException(args.getErrorMessage());
        }
        this.shutdownPort = args.getShutDownPort();
        this.tomcat.getServer().setPort(this.shutdownPort);
        this.contextPath = args.getContextPath();
        this.webAppRoot = args.getWebAppRoot();
        this.tomcat.addWebapp(this.contextPath, this.webAppRoot);
        this.tomcat.setBaseDir(args.getWorkingDirectory());
        this.httpPort = args.getHttpPort();
        this.configureDefaultConnector(this.httpPort, args.getSecurePort());
        if (args.getSecurePort() > 0) {
            connector = this.createSslConnector(args);
            this.tomcat.getService().addConnector(connector);
        }
        if (args.getAjpHttpPort() > 0) {
            connector = this.createAjpConnector(args.getAjpHttpPort(), args.getSecurePort());
            this.tomcat.getService().addConnector(connector);
        }
        if (args.getAjpSecurePort() > 0) {
            connector = this.createSecureAjpConnector(args.getAjpSecurePort());
            this.tomcat.getService().addConnector(connector);
        }
    }

    private void configureDefaultConnector(int port, int securePort) {
        System.out.println("Creating default connector on port " + port);
        this.tomcat.setPort(port);
        if (securePort > 0) {
            this.tomcat.getConnector().setRedirectPort(securePort);
        }
    }

    private Connector createSslConnector(EmbeddedArgs args) {
        System.out.println("Creating SSL connector on port " + args.getSecurePort());
        Connector connector = new Connector(Http11NioProtocol.class.getName());
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        connector.setScheme("https");
        connector.setSecure(true);
        connector.setPort(args.getSecurePort());
        protocol.setSSLEnabled(true);
        if (StringUtils.isNotBlank(args.getKeystoreFile())) {
            protocol.setKeystoreFile(args.getKeystoreFile());
        }
        if (StringUtils.isNotBlank(args.getKeystorePass())) {
            protocol.setKeystorePass(args.getKeystorePass());
        }
        if (StringUtils.isNotBlank(args.getTruststoreFile())) {
            protocol.setTruststoreFile(args.getTruststoreFile());
        }
        if (StringUtils.isNotBlank(args.getTruststorePass())) {
            protocol.setTruststorePass(args.getTruststorePass());
        }
        if (StringUtils.isNotBlank(args.getKeyAlias())) {
            protocol.setKeyAlias(args.getKeyAlias());
        }
        return connector;
    }

    private Connector createAjpConnector(int port, int securePort) {
        System.out.println("Creating standard AJP connector on port " + port);
        Connector connector = new Connector(AjpNioProtocol.class.getName());
        connector.setPort(port);
        connector.setScheme("http");
        connector.setSecure(false);
        if (securePort > 0) {
            connector.setRedirectPort(securePort);
        }
        return connector;
    }

    private Connector createSecureAjpConnector(int securePort) {
        System.out.println("Creating secured AJP connector on port " + securePort);
        Connector connector = new Connector(AjpNioProtocol.class.getName());
        connector.setPort(securePort);
        connector.setScheme("https");
        connector.setSecure(true);
        return connector;
    }

    public void start(boolean keepAlive, boolean autoShutDown) throws Exception {
        EmbeddedStatus status = this.getStatus();
        if (status.isUp()) {
            if (autoShutDown) {
                this.shutdown();
                while (this.getStatus().isUp()) {
                }
            } else {
                System.out.println("Embedded tomcat is already running.");
                return;
            }
        }
        System.out.println(String.format("Starting embedded tomcat on http://localhost:%s/%s using %s", this.httpPort, this.contextPath, this.webAppRoot));
        this.tomcat.start();
        if (keepAlive) {
            this.tomcat.getServer().await();
        }
    }

    public void shutdown() throws Exception {
        System.out.println("Shutting down embedded tomcat.");
        try (Socket localSocket = new Socket("localhost", this.shutdownPort);
             OutputStream outStream = localSocket.getOutputStream();){
            outStream.write("SHUTDOWN".getBytes());
            outStream.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EmbeddedStatus getStatus() throws Exception {
        try (Socket ignored = new Socket("localhost", this.shutdownPort);){
            EmbeddedStatus embeddedStatus = EmbeddedStatus.up;
            return embeddedStatus;
        }
        catch (Throwable e) {
            return EmbeddedStatus.down;
        }
    }
}

