package org.crazyyak.dev.embedded;

import java.io.File;
import java.util.Arrays;
import org.crazyyak.dev.common.StringUtils;

public class EmbeddedArgs {

  private final String webAppRoot;
  private String contextPath = "";
  private String workingDirectory;

  private int shutDownPort = 8005;

  private int httpPort = 8080;
  private int securePort;

  private int ajpHttpPort;
  private int ajpSecurePort;

  private String keystoreFile;
  private String keystorePass;

  private String truststoreFile;
  private String truststorePass;

  private String keyAlias;

  private boolean autoShutDown;

  public EmbeddedArgs(String...args) {
    if (args.length % 2 != 0) {
      String msg = String.format("Expected an even number of arguments, not %s: %s", args.length, Arrays.asList(args));
      throw new IllegalArgumentException(msg);
    }

    String webAppRoot = null;

    for (int i = 0; i < args.length; i += 2) {
      String key = args[i];
      String value = args[i+1];

      if ("webAppRoot".equals(key)) {
        webAppRoot = value;
      } else {
        parseArgs(key, value);
      }
    }

    this.webAppRoot = webAppRoot;
  }

  public String getErrorMessage() {
    if (StringUtils.isBlank(webAppRoot)) return "The argument webAppRoot must be specified.";
    if (StringUtils.isBlank(workingDirectory)) return "The argument workingDirectory must be specified.";
    return null;
  }

  public static void printUsage() {
    System.out.println("Arguments: webAppRoot \"{path}\"");
    System.out.println("           [contextPath \"{path}\"]");
    System.out.println("           workingDirectory \"{path}\"");
    System.out.println("           autoShutDown boolean (default false)");
    System.out.println("           shutDownPort int (default 8005)");
    System.out.println("           [httpPort int (default 8080)]");
    System.out.println("           [securePort int]");
    System.out.println("           [ajpHttpPort int]");
    System.out.println("           [ajpSecurePort int]");
    System.out.println("           [keystoreFile \"{path}\" keystorePass string]");
    System.out.println("           [truststoreFile \"{path}\" truststorePass string]");
    System.out.println("           [keyAlias string]");
  }

  private Object parseArgs(String key, String value) {
    try {
      switch (key) {
        case "contextPath":
          return contextPath = value;
        case "workingDirectory":
          return workingDirectory = value;
        case "shutDownPort":
          return shutDownPort = Integer.valueOf(value);
        case "httpPort":
          return httpPort = Integer.valueOf(value);
        case "securePort":
          return securePort = Integer.valueOf(value);
        case "ajpHttpPort":
          return ajpHttpPort = Integer.valueOf(value);
        case "ajpSecurePort":
          return ajpSecurePort = Integer.valueOf(value);
        case "keystoreFile":
          return keystoreFile = value;
        case "keystorePass":
          return keystorePass = value;
        case "truststoreFile":
          return truststoreFile = value;
        case "truststorePass":
          return truststorePass = value;
        case "keyAlias":
          return keyAlias = value;
        case "autoShutDown":
          return autoShutDown = Boolean.valueOf(value);
        default:
          String msg = String.format("");
          throw new IllegalArgumentException(msg);
      }
    } catch (NumberFormatException e) {
      String msg = String.format("Unable to parse the number \"%s\" for the argument \"%s\".", value, key);
      throw new IllegalArgumentException(msg);
    }
  }

  public EmbeddedArgs(String webAppRoot) {
    this.webAppRoot = webAppRoot;
  }
  public EmbeddedArgs(File webAppRoot) {
    this.webAppRoot = webAppRoot.getAbsolutePath();
  }

  public String getContextPath() {
    return contextPath;
  }

  public void setContextPath(String contextPath) {
    this.contextPath = contextPath;
  }

  public String getWebAppRoot() {
    return webAppRoot;
  }

  public String getWorkingDirectory() {
    return workingDirectory;
  }

  public void setWorkingDirectory(String workingDirectory) {
    this.workingDirectory = workingDirectory;
  }
  public void setWorkingDirectory(File workingDirectory) {
    this.workingDirectory = workingDirectory.getAbsolutePath();
  }

  public int getShutDownPort() {
    return shutDownPort;
  }

  public void setShutDownPort(int shutDownPort) {
    this.shutDownPort = shutDownPort;
  }

  public int getHttpPort() {
    return httpPort;
  }

  public void setHttpPort(int httpPort) {
    this.httpPort = httpPort;
  }

  public int getSecurePort() {
    return securePort;
  }

  public void setSecurePort(int securePort) {
    this.securePort = securePort;
  }

  public int getAjpHttpPort() {
    return ajpHttpPort;
  }

  public void setAjpHttpPort(int ajpHttpPort) {
    this.ajpHttpPort = ajpHttpPort;
  }

  public int getAjpSecurePort() {
    return ajpSecurePort;
  }

  public void setAjpSecurePort(int ajpSecurePort) {
    this.ajpSecurePort = ajpSecurePort;
  }

  public String getKeystoreFile() {
    return keystoreFile;
  }

  public void setKeystoreFile(String keystoreFile) {
    this.keystoreFile = keystoreFile;
  }

  public String getKeystorePass() {
    return keystorePass;
  }

  public void setKeystorePass(String keystorePass) {
    this.keystorePass = keystorePass;
  }

  public String getTruststoreFile() {
    return truststoreFile;
  }

  public void setTruststoreFile(String truststoreFile) {
    this.truststoreFile = truststoreFile;
  }

  public String getTruststorePass() {
    return truststorePass;
  }

  public void setTruststorePass(String truststorePass) {
    this.truststorePass = truststorePass;
  }

  public String getKeyAlias() {
    return keyAlias;
  }

  public void setKeyAlias(String keyAlias) {
    this.keyAlias = keyAlias;
  }

  public boolean isAutoShutDown() {
    return autoShutDown;
  }

  public void setAutoShutDown(boolean autoShutDown) {
    this.autoShutDown = autoShutDown;
  }
}
