/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.embedded.tomcat;

import java.io.File;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.ajp.AjpNioProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.crazyyak.dev.common.IoUtils;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.domain.embedded.EmbeddedAction;
import org.crazyyak.dev.domain.embedded.EmbeddedArgs;
import org.crazyyak.dev.domain.embedded.EmbeddedStatus;

public class EmbeddedTomcat {
    private final int httpPort;
    private final int shutdownPort;
    private final int shutdownTimeout;
    private final String contextPath;
    private final String webAppRoot;
    private final Tomcat tomcat = new Tomcat();

    public static void main(String ... args) {
        try {
            EmbeddedArgs embeddedArgs = new EmbeddedArgs(args);
            if (embeddedArgs.getErrorMessage() != null) {
                System.out.println(embeddedArgs.getErrorMessage());
                EmbeddedArgs.printUsage();
                System.out.flush();
                return;
            }
            int exitCode = EmbeddedAction.stop == embeddedArgs.getAction() ? EmbeddedTomcat.shutdown(embeddedArgs.getShutdownPort(), embeddedArgs.getShutdownTimeout()) : (EmbeddedAction.status == embeddedArgs.getAction() ? EmbeddedTomcat.getStatus(embeddedArgs.getShutdownPort()).getExitCode() : new EmbeddedTomcat(embeddedArgs).start(true, embeddedArgs.isAutoShutDown()));
            System.exit(exitCode);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            EmbeddedArgs.printUsage();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public EmbeddedTomcat(EmbeddedArgs args) throws Exception {
        Connector connector;
        if (args.getErrorMessage() != null) {
            throw new IllegalArgumentException(args.getErrorMessage());
        }
        IoUtils.createPath((File)new File(args.getWorkingDirectory()));
        this.tomcat.setBaseDir(args.getWorkingDirectory());
        StandardHost host = (StandardHost)this.tomcat.getHost();
        host.setAutoDeploy(false);
        host.setDeployOnStartup(true);
        host.setUnpackWARs(false);
        this.shutdownPort = args.getShutdownPort();
        this.tomcat.getServer().setPort(this.shutdownPort);
        this.shutdownTimeout = args.getShutdownTimeout();
        this.contextPath = args.getContextPath();
        this.webAppRoot = args.getWebAppRoot();
        this.tomcat.addWebapp(this.contextPath, this.webAppRoot);
        this.httpPort = args.getHttpPort();
        this.configureDefaultConnector(this.httpPort, args.getSecurePort());
        if (args.getSecurePort() > 0) {
            connector = this.createSslConnector(args);
            this.tomcat.getService().addConnector(connector);
        }
        if (args.getAjpHttpPort() > 0) {
            connector = this.createAjpConnector(args.getAjpHttpPort(), args.getSecurePort());
            this.tomcat.getService().addConnector(connector);
        }
        if (args.getAjpSecurePort() > 0) {
            connector = this.createSecureAjpConnector(args.getAjpSecurePort());
            this.tomcat.getService().addConnector(connector);
        }
    }

    private void configureDefaultConnector(int port, int securePort) {
        System.out.println("Creating default connector on port " + port);
        this.tomcat.setPort(port);
        if (securePort > 0) {
            this.tomcat.getConnector().setRedirectPort(securePort);
        }
    }

    private Connector createSslConnector(EmbeddedArgs args) {
        System.out.println("Creating SSL connector on port " + args.getSecurePort());
        Connector connector = new Connector(Http11NioProtocol.class.getName());
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        connector.setScheme("https");
        connector.setSecure(true);
        connector.setPort(args.getSecurePort());
        protocol.setSSLEnabled(true);
        if (StringUtils.isNotBlank((Object[])new Object[]{args.getKeystoreFile()})) {
            protocol.setKeystoreFile(args.getKeystoreFile());
        }
        if (StringUtils.isNotBlank((Object[])new Object[]{args.getKeystorePass()})) {
            protocol.setKeystorePass(args.getKeystorePass());
        }
        if (StringUtils.isNotBlank((Object[])new Object[]{args.getTruststoreFile()})) {
            protocol.setTruststoreFile(args.getTruststoreFile());
        }
        if (StringUtils.isNotBlank((Object[])new Object[]{args.getTruststorePass()})) {
            protocol.setTruststorePass(args.getTruststorePass());
        }
        if (StringUtils.isNotBlank((Object[])new Object[]{args.getKeyAlias()})) {
            protocol.setKeyAlias(args.getKeyAlias());
        }
        return connector;
    }

    private Connector createAjpConnector(int port, int securePort) {
        System.out.println("Creating standard AJP connector on port " + port);
        Connector connector = new Connector(AjpNioProtocol.class.getName());
        connector.setPort(port);
        connector.setScheme("http");
        connector.setSecure(false);
        if (securePort > 0) {
            connector.setRedirectPort(securePort);
        }
        return connector;
    }

    private Connector createSecureAjpConnector(int securePort) {
        System.out.println("Creating secured AJP connector on port " + securePort);
        Connector connector = new Connector(AjpNioProtocol.class.getName());
        connector.setPort(securePort);
        connector.setScheme("https");
        connector.setSecure(true);
        return connector;
    }

    public int start(boolean keepAlive, boolean autoShutDown) throws Exception {
        try {
            EmbeddedStatus status = EmbeddedTomcat.getStatus(this.shutdownPort);
            if (autoShutDown && status.isOnline()) {
                int exitCode = EmbeddedTomcat.shutdown(this.shutdownPort, this.shutdownTimeout);
                if (exitCode != 0) {
                    return exitCode;
                }
            } else if (status.isOnline()) {
                System.out.println("Embedded tomcat is already running.");
                return 1;
            }
            System.out.println(String.format("Starting embedded tomcat on http://localhost:%s/%s using %s", this.httpPort, this.contextPath, this.webAppRoot));
            long start = System.currentTimeMillis();
            this.tomcat.start();
            System.out.printf("Embedded-Tomcat application started in %s ms\n", System.currentTimeMillis() - start);
            if (keepAlive) {
                this.tomcat.getServer().await();
            }
            return 0;
        }
        catch (Throwable e) {
            System.out.printf("Embedded-Tomcat application start failed.\n", new Object[0]);
            throw e;
        }
    }

    public static int shutdown(int shutdownPort, int shutdownTimeout) throws Exception {
        if (EmbeddedTomcat.getStatus(shutdownPort).isOffline()) {
            System.out.println("Embedded tomcat is not running.");
            return 1;
        }
        System.out.printf("Shutting down embedded tomcat with a %s second timeout.\n", shutdownTimeout);
        try (Socket localSocket = new Socket("localhost", shutdownPort);
             OutputStream outStream = localSocket.getOutputStream();){
            outStream.write("SHUTDOWN".getBytes());
            outStream.flush();
        }
        long timeout = shutdownTimeout * 1000;
        long start = System.currentTimeMillis();
        do {
            EmbeddedStatus status;
            if (!(status = EmbeddedTomcat.getStatus(shutdownPort)).isOffline()) continue;
            return 0;
        } while (System.currentTimeMillis() - start <= timeout);
        System.out.printf("Failed to shutdown embedded tomcat after %s seconds.\n", shutdownTimeout);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmbeddedStatus getStatus(int shutdownPort) throws Exception {
        try (Socket ignored = new Socket("localhost", shutdownPort);){
            EmbeddedStatus embeddedStatus = EmbeddedStatus.online;
            return embeddedStatus;
        }
        catch (Throwable e) {
            return EmbeddedStatus.offline;
        }
    }
}

