package org.crazyyak.dev.jackson.test;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.FineMessageSetImpl;
import org.crazyyak.dev.common.fine.TraitMap;
import org.crazyyak.dev.domain.locality.LatLng;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

/**
 * This class is used by unit tests in this module as well as
 * by the demo app and the jersey-client module. It's made
 * public so that these apps do not require inclusion of test
 * dependencies.
 */
public class FreeBird {

  private final String injected;
  private final String missing;

  private final String stringValue;
  private final long longValue;
  private final int intValue;

  private final LatLng latLng;

  private final org.crazyyak.dev.domain.money.Money yakMoney;
  private final org.joda.money.Money jodaMoney;

  private final LocalTime localTime;
  private final LocalDate localDate;
  private final LocalDateTime localDateTime;

  private final TraitMap traitMap;
  private final FineMessage fineMessage;
  private final FineMessageSet messageSet;

  public FreeBird(String stringValue,
                  long longValue,
                  int intValue,
                  LatLng latLng,
                  org.crazyyak.dev.domain.money.Money yakMoney,
                  org.joda.money.Money jodaMoney,
                  LocalTime localTime,
                  LocalDate localDate,
                  LocalDateTime localDateTime,
                  TraitMap traitMap,
                  FineMessage fineMessage,
                  FineMessageSetImpl messageSet) {

    this.injected = null;
    this.missing = null;
    this.stringValue = stringValue;
    this.longValue = longValue;
    this.intValue = intValue;
    this.latLng = latLng;
    this.yakMoney = yakMoney;
    this.jodaMoney = jodaMoney;
    this.localTime = localTime;
    this.localDate = localDate;
    this.localDateTime = localDateTime;
    this.traitMap = traitMap;
    this.fineMessage = fineMessage;
    this.messageSet = messageSet;
  }

  @JsonCreator
  private FreeBird(@JacksonInject("injected-string") String injected,
                  @JacksonInject("missing-string") String missing,
                  @JsonProperty("stringValue") String stringValue,
                  @JsonProperty("longValue") long longValue,
                  @JsonProperty("intValue") int intValue,
                  @JsonProperty("latLng") LatLng latLng,
                  @JsonProperty("yakMoney") org.crazyyak.dev.domain.money.Money yakMoney,
                  @JsonProperty("jodaMoney") org.joda.money.Money jodaMoney,
                  @JsonProperty("localTime") LocalTime localTime,
                  @JsonProperty("localDate") LocalDate localDate,
                  @JsonProperty("localDateTime") LocalDateTime localDateTime,
                  @JsonProperty("traitMap") TraitMap traitMap,
                  @JsonProperty("fineMessage") FineMessage fineMessage,
                  @JsonProperty("messageSet") FineMessageSet messageSet) {

    this.injected = injected;
    this.missing = missing;
    this.stringValue = stringValue;
    this.longValue = longValue;
    this.intValue = intValue;
    this.latLng = latLng;
    this.yakMoney = yakMoney;
    this.jodaMoney = jodaMoney;
    this.localTime = localTime;
    this.localDate = localDate;
    this.localDateTime = localDateTime;
    this.traitMap = traitMap;
    this.fineMessage = fineMessage;
    this.messageSet = messageSet;
  }

  public String getInjected() {
    return injected;
  }

  public String getMissing() {
    return missing;
  }

  public String getStringValue() {
    return stringValue;
  }

  public long getLongValue() {
    return longValue;
  }

  public int getIntValue() {
    return intValue;
  }

  public LatLng getLatLng() {
    return latLng;
  }

  public org.crazyyak.dev.domain.money.Money getYakMoney() {
    return yakMoney;
  }

  public org.joda.money.Money getJodaMoney() {
    return jodaMoney;
  }

  public LocalTime getLocalTime() {
    return localTime;
  }

  public LocalDate getLocalDate() {
    return localDate;
  }

  public LocalDateTime getLocalDateTime() {
    return localDateTime;
  }

  public TraitMap getTraitMap() {
    return traitMap;
  }

  public FineMessage getFineMessage() {
    return fineMessage;
  }

  public FineMessageSet getMessageSet() {
    return messageSet;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof FreeBird)) return false;

    FreeBird freeBird = (FreeBird) o;

    if (intValue != freeBird.intValue) return false;
    if (longValue != freeBird.longValue) return false;
    if (fineMessage != null ? !fineMessage.equals(freeBird.fineMessage) : freeBird.fineMessage != null) return false;
    if (injected != null ? !injected.equals(freeBird.injected) : freeBird.injected != null) return false;
    if (jodaMoney != null ? !jodaMoney.equals(freeBird.jodaMoney) : freeBird.jodaMoney != null) return false;
    if (latLng != null ? !latLng.equals(freeBird.latLng) : freeBird.latLng != null) return false;
    if (localDate != null ? !localDate.equals(freeBird.localDate) : freeBird.localDate != null) return false;
    if (localDateTime != null ? !localDateTime.equals(freeBird.localDateTime) : freeBird.localDateTime != null)
      return false;
    if (localTime != null ? !localTime.equals(freeBird.localTime) : freeBird.localTime != null) return false;
    if (messageSet != null ? !messageSet.equals(freeBird.messageSet) : freeBird.messageSet != null) return false;
    if (missing != null ? !missing.equals(freeBird.missing) : freeBird.missing != null) return false;
    if (stringValue != null ? !stringValue.equals(freeBird.stringValue) : freeBird.stringValue != null) return false;
    if (traitMap != null ? !traitMap.equals(freeBird.traitMap) : freeBird.traitMap != null) return false;
    if (yakMoney != null ? !yakMoney.equals(freeBird.yakMoney) : freeBird.yakMoney != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = injected != null ? injected.hashCode() : 0;
    result = 31 * result + (missing != null ? missing.hashCode() : 0);
    result = 31 * result + (stringValue != null ? stringValue.hashCode() : 0);
    result = 31 * result + (int) (longValue ^ (longValue >>> 32));
    result = 31 * result + intValue;
    result = 31 * result + (latLng != null ? latLng.hashCode() : 0);
    result = 31 * result + (yakMoney != null ? yakMoney.hashCode() : 0);
    result = 31 * result + (jodaMoney != null ? jodaMoney.hashCode() : 0);
    result = 31 * result + (localTime != null ? localTime.hashCode() : 0);
    result = 31 * result + (localDate != null ? localDate.hashCode() : 0);
    result = 31 * result + (localDateTime != null ? localDateTime.hashCode() : 0);
    result = 31 * result + (traitMap != null ? traitMap.hashCode() : 0);
    result = 31 * result + (fineMessage != null ? fineMessage.hashCode() : 0);
    result = 31 * result + (messageSet != null ? messageSet.hashCode() : 0);
    return result;
  }
}
