package org.crazyyak.dev.jackson;

/**
* Created by jacobp on 7/21/2014.
*/
public class YakJacksonInjectable {
  private final String key;
  private final Object value;

  public YakJacksonInjectable(String key, Object value) {
    this.key = key;
    this.value = value;
  }

  public YakJacksonInjectable(Class key, Object value) {
    this.key = key.getName();
    this.value = value;
  }

  public YakJacksonInjectable(Object value) {
    this.key = value.getClass().getName();
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public Object getValue() {
    return value;
  }
}
