/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.common.json.JsonTranslator;
import org.crazyyak.dev.jackson.YakJacksonInjectable;
import org.crazyyak.dev.jackson.YakJacksonObjectMapper;

public class YakJacksonTranslator
implements JsonTranslator {
    private final ObjectMapper jacksonMapper;

    public YakJacksonTranslator() {
        this.jacksonMapper = this.createObjectMapper(YakJacksonObjectMapper.defaultModules(), Collections.emptyList());
    }

    public YakJacksonTranslator(Collection<? extends YakJacksonInjectable> injectables) {
        this.jacksonMapper = this.createObjectMapper(YakJacksonObjectMapper.defaultModules(), injectables);
    }

    public YakJacksonTranslator(Collection<? extends Module> modules, Collection<? extends YakJacksonInjectable> injectables) {
        this.jacksonMapper = this.createObjectMapper(modules, injectables);
    }

    public YakJacksonTranslator(ObjectMapper jacksonMapper) {
        this.jacksonMapper = jacksonMapper;
    }

    protected ObjectMapper createObjectMapper(Collection<? extends Module> modules, Collection<? extends YakJacksonInjectable> injectables) {
        return new YakJacksonObjectMapper(modules, injectables);
    }

    public String toJson(Object domain) {
        try {
            return this.jacksonMapper.writeValueAsString(domain).replaceAll("\r", "");
        }
        catch (JsonProcessingException e) {
            throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
        }
    }

    public <T> T fromJson(Class<T> type, String json, Class<?> ... parameterTypes) {
        if (parameterTypes != null && parameterTypes.length > 0) {
            try {
                JavaType javaType = this.jacksonMapper.getTypeFactory().constructParametricType(type, (Class[])parameterTypes);
                return (T)this.jacksonMapper.readValue(json, javaType);
            }
            catch (IOException e) {
                throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
            }
        }
        try {
            return (T)this.jacksonMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
        }
    }
}

