/*
 * Copyright 2012 Jacob D Parr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.crazyyak.dev.jackson;

import org.crazyyak.dev.common.fine.*;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.crazyyak.dev.domain.locality.LatLng;
import org.crazyyak.dev.domain.query.QueryResult;

public class YakJacksonModule extends SimpleModule {

  public YakJacksonModule() {

    addSerializer(new YakMoneySerializer());
    addDeserializer(org.crazyyak.dev.domain.money.Money.class, new YakMoneyDeserializer());

    addSerializer(new JodaMoneySerializer());
    addDeserializer(org.joda.money.Money.class, new JodaMoneyDeserializer());

    addSerializer(new TraitMapSerializer());
    addDeserializer(TraitMap.class, new TraitMapDeserializer());

    addSerializer(new FineMessageSetSerializer());
    addDeserializer(FineMessageSet.class, new FineMessageSetDeserializer());

    addSerializer(new QueryResultSerializer());
    addDeserializer(QueryResult.class, new QueryResultDeserializer());

    setMixInAnnotation(LatLng.class, LatLngMixin.class);
    setMixInAnnotation(FineMessage.class, FineMessageMixin.class);

  }
}
