/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public final class JodaMoneyDeserializer
extends StdScalarDeserializer<Money> {
    private final CurrencyUnit currency;

    public JodaMoneyDeserializer() {
        super(Money.class);
        this.currency = CurrencyUnit.USD;
    }

    public JodaMoneyDeserializer(CurrencyUnit currency) {
        super(Money.class);
        this.currency = currency;
    }

    public Money deserialize(JsonParser jp, DeserializationContext context) throws IOException, JsonProcessingException {
        String amount = (String)jp.readValueAs(String.class);
        return Money.of((CurrencyUnit)this.currency, (BigDecimal)new BigDecimal(amount));
    }
}

