/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.TraitMap;
import org.crazyyak.dev.domain.account.AccountStatus;
import org.crazyyak.dev.domain.locality.LatLng;
import org.crazyyak.dev.domain.money.Money;
import org.crazyyak.dev.domain.query.QueryResult;
import org.crazyyak.dev.jackson.mixins.AccountStatusMixin;
import org.crazyyak.dev.jackson.mixins.LatLngMixin;
import org.crazyyak.dev.jackson.money.YakMoneyDeserializer;
import org.crazyyak.dev.jackson.money.YakMoneySerializer;
import org.crazyyak.dev.jackson.msg.FineMessageMixin;
import org.crazyyak.dev.jackson.msg.FineMessageSetDeserializer;
import org.crazyyak.dev.jackson.msg.FineMessageSetSerializer;
import org.crazyyak.dev.jackson.qry.QueryResultDeserializer;
import org.crazyyak.dev.jackson.qry.QueryResultSerializer;
import org.crazyyak.dev.jackson.time.LocalDateDeserializer;
import org.crazyyak.dev.jackson.time.LocalDateSerializer;
import org.crazyyak.dev.jackson.time.LocalDateTimeDeserializer;
import org.crazyyak.dev.jackson.time.LocalDateTimeSerializer;
import org.crazyyak.dev.jackson.time.LocalTimeDeserializer;
import org.crazyyak.dev.jackson.time.LocalTimeSerializer;
import org.crazyyak.dev.jackson.time.ZonedDateTimeDeserializer;
import org.crazyyak.dev.jackson.time.ZonedDateTimeSerializer;
import org.crazyyak.dev.jackson.trait.TraitMapDeserializer;
import org.crazyyak.dev.jackson.trait.TraitMapSerializer;

public class YakJacksonModule
extends SimpleModule {
    public YakJacksonModule() {
        this.add(Money.class, (JsonSerializer)new YakMoneySerializer(), (JsonDeserializer)new YakMoneyDeserializer());
        this.add(TraitMap.class, (JsonSerializer)new TraitMapSerializer(), (JsonDeserializer)new TraitMapDeserializer());
        this.add(FineMessageSet.class, (JsonSerializer)new FineMessageSetSerializer(), (JsonDeserializer)new FineMessageSetDeserializer());
        this.add(QueryResult.class, (JsonSerializer)new QueryResultSerializer(), (JsonDeserializer)new QueryResultDeserializer());
        this.add(LocalDate.class, (JsonSerializer)new LocalDateSerializer(), (JsonDeserializer)new LocalDateDeserializer());
        this.add(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(), (JsonDeserializer)new LocalTimeDeserializer());
        this.add(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(), (JsonDeserializer)new LocalDateTimeDeserializer());
        this.add(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer(), (JsonDeserializer)new ZonedDateTimeDeserializer());
        this.setMixInAnnotation(LatLng.class, LatLngMixin.class);
        this.setMixInAnnotation(FineMessage.class, FineMessageMixin.class);
        this.setMixInAnnotation(AccountStatus.class, AccountStatusMixin.class);
        this.add("org.joda.money.Money", "org.crazyyak.lib.joda.jackson.JodaMoneySerializer", "org.crazyyak.lib.joda.jackson.JodaMoneyDeserializer");
        this.add("org.joda.time.DateMidnight", "com.fasterxml.jackson.datatype.joda.ser.DateMidnightSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateMidnightDeserializer");
        this.add("org.joda.time.DateTime", "com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateTimeDeserializer");
        this.add("org.joda.time.DateTimeZone", "com.fasterxml.jackson.datatype.joda.ser.DateTimeZoneSerializer", "com.fasterxml.jackson.datatype.joda.deser.DateTimeZoneDeserializer");
        this.add("org.joda.time.Duration", "com.fasterxml.jackson.datatype.joda.ser.DurationSerializer", "com.fasterxml.jackson.datatype.joda.deser.DurationDeserializer");
        this.add("org.joda.time.Instant", "com.fasterxml.jackson.datatype.joda.ser.InstantSerializer", "com.fasterxml.jackson.datatype.joda.deser.InstantDeserializer");
        this.add("org.joda.time.LocalDateTime", "com.fasterxml.jackson.datatype.joda.ser.LocalDateTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalDateTimeDeserializer");
        this.add("org.joda.time.LocalDate", "com.fasterxml.jackson.datatype.joda.ser.LocalDateSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalDateDeserializer");
        this.add("org.joda.time.LocalTime", "com.fasterxml.jackson.datatype.joda.ser.LocalTimeSerializer", "com.fasterxml.jackson.datatype.joda.deser.LocalTimeDeserializer");
        this.add("org.joda.time.Period", "com.fasterxml.jackson.datatype.joda.ser.PeriodSerializer", "com.fasterxml.jackson.datatype.joda.deser.PeriodDeserializer");
        this.add("org.joda.time.Interval", "com.fasterxml.jackson.datatype.joda.ser.IntervalSerializer", "com.fasterxml.jackson.datatype.joda.deser.IntervalDeserializer");
        this.add("org.joda.time.MonthDay", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", "com.fasterxml.jackson.datatype.joda.deser.MonthDayDeserializer");
        this.add("org.joda.time.YearMonth", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", "com.fasterxml.jackson.datatype.joda.deser.YearMonthDeserializer");
    }

    private void add(Class type, JsonSerializer serializer, JsonDeserializer deserializer) {
        this.addSerializer(type, serializer);
        this.addDeserializer(type, deserializer);
    }

    private void add(String typeName, String serializerClassName, String deserializerClassName) {
        try {
            Class<?> type = Class.forName(typeName);
            Class<?> jsonSerializerClass = Class.forName(serializerClassName);
            JsonSerializer serializer = (JsonSerializer)jsonSerializerClass.newInstance();
            this.addSerializer(type, serializer);
            Class<?> jsonDeserializerClass = Class.forName(deserializerClassName);
            if (deserializerClassName.equals("com.fasterxml.jackson.datatype.joda.deser.DateTimeDeserializer")) {
                Class<?> dateTimeType = Class.forName("org.joda.time.DateTime");
                Constructor<?> constructor = jsonDeserializerClass.getConstructor(Class.class);
                JsonDeserializer deserializer = (JsonDeserializer)constructor.newInstance(dateTimeType);
                this.addDeserializer(type, deserializer);
            } else {
                JsonDeserializer deserializer = (JsonDeserializer)jsonDeserializerClass.newInstance();
                this.addDeserializer(type, deserializer);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

