/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.rest.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.crazyyak.dev.common.IoUtils;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.common.json.JsonTranslator;
import org.crazyyak.dev.common.net.HttpStatusCode;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;

public class SimpleRestClient {
    public static final Map<String, Object> EMPTY_QUERY = Collections.emptyMap();
    protected final JsonTranslator translator;
    private final String apiUrl;
    private final String userName;
    private final String password;

    public SimpleRestClient(JsonTranslator translator, String apiUrl, String userName, String password) {
        this.apiUrl = apiUrl;
        this.userName = userName;
        this.password = password;
        this.translator = translator;
    }

    public void post(String subUrl) {
        this.post(null, subUrl, null);
    }

    public void post(String subUrl, Object entity) {
        this.post(null, subUrl, entity);
    }

    public <T> T post(Class returnType, String subUrl) {
        return this.post(returnType, subUrl, null);
    }

    public <T> T post(Class returnType, String subUrl, Object entity) {
        Invocation.Builder builder = this.builder(subUrl, Collections.emptyMap(), "application/json");
        String json = entity == null ? null : this.translator.toJson(entity);
        Response response = builder.post(Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        this.assertResponse(response.getStatus());
        json = (String)response.readEntity(String.class);
        return (T)(returnType == null ? null : this.translator.fromJson(returnType, json, new Class[0]));
    }

    public <T> T get(Class returnType, String subUrl, String ... queryStrings) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.putAll(this.toMap(queryStrings));
        return this.get(returnType, subUrl, queryMap, "application/json");
    }

    public <T> T get(Class returnType, String subUrl, Map<String, Object> queryMap) {
        return this.get(returnType, subUrl, queryMap, "application/json");
    }

    public byte[] getBytes(String subUrl, Map<String, Object> queryMap, String ... acceptedResponseTypes) throws IOException {
        Invocation.Builder builder = this.builder(subUrl, queryMap, acceptedResponseTypes);
        Response response = (Response)builder.get(Response.class);
        this.assertResponse(response.getStatus());
        InputStream in = (InputStream)response.getEntity();
        return IoUtils.toBytes((InputStream)in);
    }

    public <T> T get(Class returnType, String subUrl, Map<String, Object> queryMap, String ... acceptedResponseTypes) {
        String retValue;
        Invocation.Builder builder = this.builder(subUrl, queryMap, acceptedResponseTypes);
        Response response = (Response)builder.get(Response.class);
        this.assertResponse(response.getStatus());
        String content = (String)response.readEntity(String.class);
        if (returnType == null) {
            return null;
        }
        if (returnType.isPrimitive() || returnType.isArray() && returnType.getComponentType().isPrimitive()) {
            retValue = content;
        } else if (String.class.equals((Object)returnType)) {
            retValue = content.replaceAll("\r", "");
        } else {
            return (T)this.translator.fromJson(returnType, content, new Class[0]);
        }
        return (T)retValue;
    }

    public JsonTranslator getTranslator() {
        return this.translator;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    protected void assertResponse(int status) {
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)status);
        if (!statusCode.isOk()) {
            String msg = String.format("Unexpected response: %s %s", status, statusCode.getReason());
            throw new ApiException(statusCode, msg, new String[0]);
        }
    }

    protected Map<String, Object> toMap(String ... keyValuePairs) {
        if (keyValuePairs == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String pair : keyValuePairs) {
            int pos;
            int n = pos = pair == null ? -1 : pair.indexOf("=");
            if (pair == null) {
                map.put(null, null);
                continue;
            }
            if (pos < 0) {
                map.put(pair, null);
                continue;
            }
            String key = pair.substring(0, pos);
            String value = pair.substring(pos + 1);
            map.put(key, value);
        }
        return map;
    }

    protected Invocation.Builder builder(String url, Map<String, Object> queryMap, String ... acceptedResponseTypes) {
        Client client = ClientBuilder.newBuilder().build();
        JerseyUriBuilder uriBuilder = new JerseyUriBuilder().uri(this.getApiUrl()).path(url);
        for (Map.Entry<String, Object> queryParam : queryMap.entrySet()) {
            uriBuilder.queryParam(queryParam.getKey(), new Object[]{queryParam.getValue()});
        }
        WebTarget target = client.target((UriBuilder)uriBuilder);
        if (StringUtils.isNotBlank((Object[])new Object[]{this.getUserName()})) {
            target = (WebTarget)target.register((Object)HttpAuthenticationFeature.basic((String)this.getUserName(), (String)this.getPassword()));
        }
        return target.request(acceptedResponseTypes);
    }
}

