/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jerseyclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.crazyyak.dev.common.IoUtils;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.common.json.JsonTranslator;
import org.crazyyak.dev.common.net.HttpStatusCode;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;

public class SimpleRestClient {
    public static final Map<String, Object> EMPTY_QUERY = Collections.emptyMap();
    private final boolean notFoundToNull;
    private final JsonTranslator translator;
    private final String apiUrl;
    private final String userName;
    private final String password;

    public SimpleRestClient(JsonTranslator translator, String apiUrl) {
        this(true, translator, SimpleRestClient.parseUrl(apiUrl), SimpleRestClient.parseUserFromUrl(apiUrl), SimpleRestClient.parsePassFromUrl(apiUrl));
    }

    public SimpleRestClient(JsonTranslator translator, String apiUrl, String authentication) {
        this(true, translator, SimpleRestClient.parseUrl(apiUrl), SimpleRestClient.parseUserFromAuth(authentication), SimpleRestClient.parsePassFromAuth(authentication));
    }

    public SimpleRestClient(JsonTranslator translator, String apiUrl, String userName, String password) {
        this(true, translator, SimpleRestClient.parseUrl(apiUrl), userName, password);
    }

    public SimpleRestClient(boolean notFoundToNull, JsonTranslator translator, String apiUrl, String userName, String password) {
        this.apiUrl = apiUrl;
        this.userName = userName;
        this.password = password;
        this.translator = translator;
        this.notFoundToNull = notFoundToNull;
    }

    public static String parseUrl(String apiUrl) {
        if (StringUtils.isBlank((Object)apiUrl)) {
            return null;
        }
        String auth = SimpleRestClient.parseAuth(apiUrl);
        if (StringUtils.isBlank((Object)auth)) {
            return apiUrl;
        }
        if (apiUrl.toLowerCase().startsWith("http://")) {
            return apiUrl.replace("http://" + auth + "@", "http://");
        }
        if (apiUrl.toLowerCase().startsWith("https://")) {
            return apiUrl.replace("https://" + auth + "@", "https://");
        }
        String msg = String.format("Unable to parse the specified URL - does not start with \"http://\" or \"https://\".", new Object[0]);
        throw new IllegalArgumentException(msg);
    }

    public static String parseAuth(String apiUrl) {
        String left;
        int pos;
        if (StringUtils.isBlank((Object)apiUrl)) {
            return null;
        }
        if (apiUrl.toLowerCase().startsWith("http://")) {
            pos = 7;
        } else if (apiUrl.toLowerCase().startsWith("https://")) {
            pos = 8;
        } else {
            String msg = String.format("Unable to parse the specified URL - does not start with \"http://\" or \"https://\".", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        String contents = apiUrl.substring(pos);
        pos = contents.indexOf("/");
        if (pos < 0) {
            pos = contents.length();
        }
        if ((pos = (left = contents.substring(0, pos)).indexOf("@")) < 0) {
            return null;
        }
        return left.substring(0, pos);
    }

    public static String parseUserFromUrl(String apiUrl) {
        String auth = SimpleRestClient.parseAuth(apiUrl);
        return SimpleRestClient.parseUserFromAuth(auth);
    }

    public static String parsePassFromUrl(String apiUrl) {
        String auth = SimpleRestClient.parseAuth(apiUrl);
        return SimpleRestClient.parsePassFromAuth(auth);
    }

    public static String parseUserFromAuth(String authentication) {
        if (StringUtils.isBlank((Object)authentication)) {
            return null;
        }
        int pos = authentication.indexOf(":");
        if (pos < 0) {
            return authentication;
        }
        String name = authentication.substring(0, pos);
        return StringUtils.isNotBlank((Object)name) ? name : null;
    }

    public static String parsePassFromAuth(String authentication) {
        if (StringUtils.isBlank((Object)authentication)) {
            return null;
        }
        int pos = authentication.indexOf(":");
        if (pos < 0) {
            return null;
        }
        String pass = authentication.substring(pos + 1);
        return StringUtils.isNotBlank((Object)pass) ? pass : null;
    }

    public void post(String subUrl) {
        this.post(null, subUrl, null);
    }

    public void post(String subUrl, Object entity) {
        this.post(null, subUrl, entity);
    }

    public <T> T post(Class<T> returnType, String subUrl) {
        return this.post(returnType, subUrl, null);
    }

    public <T> T post(Class<T> returnType, String subUrl, Object entity) {
        Invocation.Builder builder = this.builder(subUrl, Collections.emptyMap(), "application/json");
        String json = entity == null ? null : this.translator.toJson(entity);
        Response response = builder.post(Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return this.translateResponse(returnType, response);
    }

    public <T> T get(Class<T> returnType, String subUrl, String ... queryStrings) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.putAll(this.toMap(queryStrings));
        return this.get(returnType, subUrl, queryMap, "application/json");
    }

    public <T> T get(Class<T> returnType, String subUrl, Map<String, Object> queryMap) {
        return this.get(returnType, subUrl, queryMap, "application/json");
    }

    public <T> T get(Class<T> returnType, String subUrl, Map<String, Object> queryMap, String ... acceptedResponseTypes) {
        Invocation.Builder builder = this.builder(subUrl, queryMap, acceptedResponseTypes);
        Response response = (Response)builder.get(Response.class);
        return this.translateResponse(returnType, response);
    }

    private <T> T translateResponse(Class<T> returnType, Response response) {
        Object retValue;
        if (response.getStatus() == 404 && this.notFoundToNull) {
            return null;
        }
        this.assertResponse(response.getStatus());
        if (returnType == null) {
            return null;
        }
        if (Response.class.equals(returnType)) {
            retValue = response;
        } else {
            String content = (String)response.readEntity(String.class);
            retValue = String.class.equals(returnType) ? content.replaceAll("\r", "") : this.translator.fromJson(returnType, content, new Class[0]);
        }
        return (T)retValue;
    }

    public byte[] getBytes(String subUrl, Map<String, Object> queryMap, String ... acceptedResponseTypes) throws IOException {
        Invocation.Builder builder = this.builder(subUrl, queryMap, acceptedResponseTypes);
        Response response = (Response)builder.get(Response.class);
        if (response.getStatus() == 404 && this.notFoundToNull) {
            return null;
        }
        this.assertResponse(response.getStatus());
        InputStream in = (InputStream)response.getEntity();
        return IoUtils.toBytes((InputStream)in);
    }

    public <T> List<T> getList(Class<T> returnType, String subUrl, String ... queryStrings) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.putAll(this.toMap(queryStrings));
        return this.getList(returnType, subUrl, queryMap);
    }

    public <T> List<T> getList(Class<T> returnType, String subUrl, Map<String, Object> queryMap) {
        Invocation.Builder builder = this.builder(subUrl, queryMap, "application/json");
        Response response = builder.get();
        if (response.getStatus() == 404 && this.notFoundToNull) {
            return null;
        }
        this.assertResponse(response.getStatus());
        String content = (String)response.readEntity(String.class);
        return (List)this.translator.fromJson(List.class, content, new Class[]{returnType});
    }

    public JsonTranslator getTranslator() {
        return this.translator;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    protected void assertResponse(int status) {
        HttpStatusCode statusCode = HttpStatusCode.findByCode((int)status);
        if (!statusCode.isOk()) {
            String msg = String.format("Unexpected response: %s %s", status, statusCode.getReason());
            throw new ApiException(statusCode, msg, new String[0]);
        }
    }

    protected Map<String, Object> toMap(String ... keyValuePairs) {
        if (keyValuePairs == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String pair : keyValuePairs) {
            int pos;
            int n = pos = pair == null ? -1 : pair.indexOf("=");
            if (pair == null) {
                map.put(null, null);
                continue;
            }
            if (pos < 0) {
                map.put(pair, null);
                continue;
            }
            String key = pair.substring(0, pos);
            String value = pair.substring(pos + 1);
            map.put(key, value);
        }
        return map;
    }

    protected Invocation.Builder builder(String url, Map<String, Object> queryMap, String ... acceptedResponseTypes) {
        Client client = ClientBuilder.newBuilder().build();
        JerseyUriBuilder uriBuilder = new JerseyUriBuilder().uri(this.getApiUrl()).path(url);
        for (Map.Entry<String, Object> queryParam : queryMap.entrySet()) {
            uriBuilder.queryParam(queryParam.getKey(), new Object[]{queryParam.getValue()});
        }
        WebTarget target = client.target((UriBuilder)uriBuilder);
        if (StringUtils.isNotBlank((Object)this.getUserName())) {
            target = (WebTarget)target.register((Object)HttpAuthenticationFeature.basic((String)this.getUserName(), (String)this.getPassword()));
        }
        return target.request(acceptedResponseTypes);
    }
}

