/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jerseyspring;

import java.util.ArrayList;
import java.util.EventListener;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.crazyyak.dev.common.ReflectUtils;
import org.crazyyak.dev.common.StringUtils;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.core.annotation.Order;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

@Order(value=0)
public abstract class YakWebAppInitializer
implements WebApplicationInitializer {
    public abstract Class<? extends ResourceConfig> getApplicationClass();

    public abstract String getEnvironmentPropertyName();

    protected abstract String getProfilesPropertyName();

    protected abstract String getSpringConfigLocation();

    public void onStartup(ServletContext servletContext) throws ServletException {
        XmlWebApplicationContext appContext = new XmlWebApplicationContext();
        appContext.setConfigLocation(this.getSpringConfigLocation());
        String[] profiles = this.getSpringProfiles();
        appContext.getEnvironment().setActiveProfiles(profiles);
        appContext.refresh();
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)appContext));
        this.registerSpringSecurityFilter(servletContext);
        this.configureJerseyFilter(servletContext);
        this.registerJspfServlet(servletContext);
    }

    protected void registerSpringSecurityFilter(ServletContext servletContext) {
        FilterRegistration.Dynamic securityFilter = servletContext.addFilter("springSecurityFilterChain", DelegatingFilterProxy.class);
        securityFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    protected void configureJerseyFilter(ServletContext servletContext) {
        servletContext.setInitParameter("contextConfigLocation", "");
        FilterRegistration.Dynamic jerseyFilter = servletContext.addFilter("jersey-filter", ServletContainer.class);
        jerseyFilter.setInitParameter("javax.ws.rs.Application", this.getApplicationClass().getName());
        jerseyFilter.setInitParameter("jersey.config.servlet.filter.forwardOn404", "true");
        jerseyFilter.setInitParameter("jersey.config.servlet.filter.staticContentRegex", "([^\\s]+(\\.(?i)(html|jpg|png|gif|bmp|css|js|ico))$)");
        jerseyFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    protected void registerJspfServlet(ServletContext servletContext) {
        servletContext.getServletRegistration("jsp").addMapping(new String[]{"*.jspf"});
    }

    protected String[] getSpringProfiles() {
        String environmentName = System.getProperty(this.getEnvironmentPropertyName(), "null");
        String envProfileName = "env-" + environmentName;
        String defaultProfiles = StringUtils.concat((String)",", (String[])new String[]{"main", "live", envProfileName});
        String profilesString = System.getProperty(this.getProfilesPropertyName(), defaultProfiles);
        ArrayList<String> profiles = new ArrayList<String>();
        for (String profile : profilesString.split(",")) {
            profiles.add(profile.trim());
        }
        return (String[])ReflectUtils.toArray(String.class, profiles);
    }
}

