/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jerseyspring;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.springframework.security.authentication.BadCredentialsException;

@Provider
public class YakExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Log log = LogFactory.getLog(YakExceptionMapper.class);
    @Context
    protected UriInfo uriInfo;

    public YakExceptionMapper() {
        log.info((Object)"Created exception mapper");
    }

    public Response toResponse(Throwable ex) {
        Response response;
        if (ex instanceof BadCredentialsException) {
            this.logException(ex, 403);
            return this.createResponse_403(ex);
        }
        if (ex instanceof ApiException) {
            ApiException apiEx = (ApiException)ex;
            if (apiEx.getHttpStatus() == 400) {
                return this.createResponse_400(ex);
            }
            if (apiEx.getHttpStatus() == 403) {
                return this.createResponse_403(ex);
            }
            if (apiEx.getHttpStatus() == 404) {
                return this.createResponse_404(ex);
            }
            if (apiEx.getHttpStatus() == 405) {
                return this.createResponse_405(ex);
            }
            response = Response.status((int)apiEx.getHttpStatus()).entity((Object)ex.getMessage()).type("text/plain").build();
        } else if (ex instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)ex;
            if (wae.getResponse() == null) {
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).type("text/plain").build();
            } else {
                response = wae.getResponse();
                int status = response.getStatus();
                if (status == 400) {
                    return this.createResponse_400(ex);
                }
                if (status == 403) {
                    return this.createResponse_403(ex);
                }
                if (status == 404) {
                    return this.createResponse_404(ex);
                }
                if (status == 405) {
                    return this.createResponse_405(ex);
                }
            }
        } else {
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)ex.getMessage()).build();
        }
        this.logException(ex, response.getStatus());
        return response;
    }

    protected void logException(Throwable throwable, int status) {
        String msg = "Status " + status;
        if (this.uriInfo != null) {
            msg = msg + " ";
            msg = msg + this.uriInfo.getRequestUri();
        }
        if (400 == status) {
            log.info((Object)msg, throwable);
        } else {
            log.error((Object)msg, throwable);
        }
    }

    protected Response createResponse_400(Throwable ex) {
        this.logException(ex, 400);
        return Response.status((int)400).entity((Object)ex.getMessage()).type("text/plain").build();
    }

    protected Response createResponse_403(Throwable ex) {
        this.logException(ex, 403);
        return Response.status((int)403).entity((Object)ex.getMessage()).type("text/plain").build();
    }

    protected Response createResponse_404(Throwable ex) {
        this.logException(ex, 404);
        return Response.status((int)404).entity((Object)ex.getMessage()).type("text/plain").build();
    }

    protected Response createResponse_405(Throwable ex) {
        this.logException(ex, 405);
        return Response.status((int)405).entity((Object)ex.getMessage()).type("text/plain").build();
    }
}

