/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jerseyspring;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.glassfish.jersey.server.mvc.Viewable;

final class YakRequestDispatcherWrapper
implements RequestDispatcher {
    static final String BASE_PATH_ATTRIBUTE_NAME = "_basePath";
    static final String OLD_MODEL_ATTRIBUTE_NAME = "it";
    static final String MODEL_ATTRIBUTE_NAME = "model";
    static final String RESOLVING_CLASS_ATTRIBUTE_NAME = "resolvingClass";
    static final String REQUEST_ATTRIBUTE_NAME = "_request";
    static final String RESPONSE_ATTRIBUTE_NAME = "_response";
    private final RequestDispatcher dispatcher;
    private final String basePath;
    private final Viewable viewable;

    public YakRequestDispatcherWrapper(RequestDispatcher dispatcher, String basePath, Viewable viewable) {
        this.dispatcher = dispatcher;
        this.basePath = basePath;
        this.viewable = viewable;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Object oldIt = request.getAttribute(MODEL_ATTRIBUTE_NAME);
        Object oldResolvingClass = request.getAttribute(RESOLVING_CLASS_ATTRIBUTE_NAME);
        request.setAttribute(RESOLVING_CLASS_ATTRIBUTE_NAME, (Object)this.viewable.getResolvingClass());
        request.setAttribute(OLD_MODEL_ATTRIBUTE_NAME, this.viewable.getModel());
        request.setAttribute(MODEL_ATTRIBUTE_NAME, this.viewable.getModel());
        request.setAttribute(BASE_PATH_ATTRIBUTE_NAME, (Object)this.basePath);
        request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)request);
        request.setAttribute(RESPONSE_ATTRIBUTE_NAME, (Object)response);
        this.dispatcher.forward(request, response);
        request.setAttribute(RESOLVING_CLASS_ATTRIBUTE_NAME, oldResolvingClass);
        request.setAttribute(MODEL_ATTRIBUTE_NAME, oldIt);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }
}

