/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jerseyspring.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.crazyyak.dev.common.IoUtils;
import org.crazyyak.dev.jerseyspring.jackson.BaseReaderWriterProvider;

public abstract class JacksonReaderWriterProvider
extends BaseReaderWriterProvider {
    private final ObjectMapper objectMapper;

    public JacksonReaderWriterProvider(ObjectMapper objectMapper, MediaType mediaType) {
        super(Arrays.asList(mediaType));
        this.objectMapper = objectMapper;
    }

    public JacksonReaderWriterProvider(ObjectMapper objectMapper, Collection<MediaType> mediaTypes) {
        super(mediaTypes);
        this.objectMapper = objectMapper;
    }

    public JacksonReaderWriterProvider(ObjectMapper objectMapper, Collection<Class> supportedTypes, Collection<MediaType> mediaTypes, boolean supportsArrays, boolean supportsEnums, boolean supportsPrimitives) {
        super(supportedTypes, mediaTypes, supportsArrays, supportsEnums, supportsPrimitives);
        this.objectMapper = objectMapper;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> map, InputStream stream) throws IOException, WebApplicationException {
        String json = IoUtils.toString((InputStream)stream);
        return this.objectMapper.readValue(json, type);
    }

    public void writeTo(Object value, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> map, OutputStream stream) throws IOException, WebApplicationException {
        String json = this.objectMapper.writeValueAsString(value);
        stream.write(json.getBytes());
    }
}

