/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jerseyspring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.crazyyak.dev.common.ReflectUtils;
import org.crazyyak.dev.common.StringUtils;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.core.annotation.Order;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

@Order(value=0)
public abstract class YakJerseyWebAppInitializer
implements WebApplicationInitializer {
    public abstract Class<? extends ResourceConfig> getApplicationClass(ServletContext var1, WebApplicationContext var2);

    public abstract String getEnvironmentPropertyName(ServletContext var1, WebApplicationContext var2);

    protected abstract String getProfilesPropertyName(ServletContext var1, WebApplicationContext var2);

    protected abstract Class<?>[] getSpringConfigClasses(ServletContext var1, WebApplicationContext var2);

    public void onStartup(ServletContext servletContext) throws ServletException {
        WebApplicationContext appContext = this.createWebApplicationContext(servletContext);
        this.addListeners(servletContext, appContext);
        this.addFilters(servletContext, appContext);
        this.addServlets(servletContext, appContext);
    }

    protected void addFilters(ServletContext servletContext, WebApplicationContext appContext) {
        this.addSpringSecurityFilter(servletContext, appContext);
        this.addJerseyFilter(servletContext, appContext);
    }

    protected void addListeners(ServletContext servletContext, WebApplicationContext appContext) {
        servletContext.addListener((EventListener)new ContextLoaderListener(appContext));
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext) {
        String[] profiles;
        AnnotationConfigWebApplicationContext appContext = new AnnotationConfigWebApplicationContext();
        Class[] configClasses = this.getSpringConfigClasses(servletContext, (WebApplicationContext)appContext);
        if (configClasses != null && configClasses.length > 0) {
            appContext.register(configClasses);
        }
        if ((profiles = this.getSpringProfiles(servletContext, (WebApplicationContext)appContext)) != null && profiles.length > 0) {
            appContext.getEnvironment().setActiveProfiles(profiles);
        }
        appContext.setServletContext(servletContext);
        appContext.refresh();
        return appContext;
    }

    protected void addSpringSecurityFilter(ServletContext servletContext, WebApplicationContext appContext) {
        FilterRegistration.Dynamic securityFilter = servletContext.addFilter("springSecurityFilterChain", DelegatingFilterProxy.class);
        securityFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    protected void addJerseyFilter(ServletContext servletContext, WebApplicationContext appContext) {
        servletContext.setInitParameter("contextConfigLocation", "");
        FilterRegistration.Dynamic jerseyFilter = servletContext.addFilter("jersey-filter", ServletContainer.class);
        jerseyFilter.setInitParameter("javax.ws.rs.Application", this.getApplicationClass(servletContext, appContext).getName());
        jerseyFilter.setInitParameter("jersey.config.servlet.filter.forwardOn404", "true");
        jerseyFilter.setInitParameter("jersey.config.servlet.filter.staticContentRegex", this.buildStaticContentRegex());
        jerseyFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    protected String buildStaticContentRegex() {
        String staticPattern = "";
        for (String urlPattern : this.getStaticResourceUrlPatterns()) {
            staticPattern = staticPattern + (staticPattern.isEmpty() ? urlPattern : "|" + urlPattern);
        }
        staticPattern = "([^\\s]+(\\.(?i)(" + staticPattern + "))$)";
        return staticPattern;
    }

    protected Collection<String> getStaticResourceUrlPatterns() {
        return Arrays.asList("html", "jpg", "png", "gif", "bmp", "css", "js", "ico", "pdf", "txt");
    }

    protected void addServlets(ServletContext servletContext, WebApplicationContext appContext) {
        this.addJspfServlet(servletContext, appContext);
    }

    protected void addJspfServlet(ServletContext servletContext, WebApplicationContext appContext) {
        servletContext.getServletRegistration("jsp").addMapping(new String[]{"*.jspf"});
    }

    protected String[] getSpringProfiles(ServletContext servletContext, WebApplicationContext appContext) {
        String environmentName = System.getProperty(this.getEnvironmentPropertyName(servletContext, appContext), "null");
        String envProfileName = "env-" + environmentName;
        String defaultProfiles = StringUtils.concat((String)",", (String[])new String[]{"main", "live", envProfileName});
        String profilesString = System.getProperty(this.getProfilesPropertyName(servletContext, appContext), defaultProfiles);
        ArrayList<String> profiles = new ArrayList<String>();
        for (String profile : profilesString.split(",")) {
            profiles.add(profile.trim());
        }
        return (String[])ReflectUtils.toArray(String.class, profiles);
    }
}

