package org.crazyyak.dev.jerseyspring;

import javax.ws.rs.*;
import javax.ws.rs.core.*;
import org.glassfish.jersey.server.mvc.MvcFeature;

@ConstrainedTo(RuntimeType.SERVER)
public class YakJspMvcFeature implements Feature {

  public static final String SUPPORTED_EXTENSIONS = "org.crazyyak.dev.jersey-spring.supportedExtensions";

  @Override
  public boolean configure(FeatureContext context) {

    final Configuration config = context.getConfiguration();

    if (config.isRegistered(YakJspTemplateProcessor.class) == false) {
      context.register(YakJspTemplateProcessor.class);

      if (config.isRegistered(MvcFeature.class) == false) {
        context.register(MvcFeature.class);
      }

      return true;
    }

    return false;
  }
}
