/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.jerseyspring;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;

public class ThymeleafTemplateProcessor
implements TemplateProcessor<String> {
    private static TemplateEngine templateEngine;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;

    @Inject
    public ThymeleafTemplateProcessor(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
    }

    public String resolve(String name, MediaType mediaType) {
        File file;
        boolean exists;
        String path = name;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return (exists = (file = new File(path = this.servletContext.getRealPath(path))).exists()) ? name : null;
    }

    public void writeTo(String templateReference, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
        if (!templateReference.startsWith("/")) {
            templateReference = "/" + templateReference;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("it", viewable.getModel());
        WebContext webContext = new WebContext(this.request, this.response, this.servletContext, Locale.getDefault(), variables);
        String output = templateEngine.process(templateReference, (IContext)webContext);
        out.write(output.getBytes());
    }

    static {
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver();
        templateResolver.setTemplateMode("XHTML");
        templateResolver.setCacheTTLMs(Long.valueOf(0L));
        templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
    }
}

