/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.domain.account.AccountStatus;
import org.crazyyak.dev.domain.account.CurrentUserSource;
import org.crazyyak.dev.domain.account.Permissions;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CurrentUser
implements UserDetails {
    public static final String INVALID_USER_NAME_OR_PASSWORD = "Invalid user name or password";
    private final String username;
    private final String accountId;
    private final String password;
    private final Permissions permissions;
    private final AccountStatus accountStatus;

    public CurrentUser(CurrentUserSource source) {
        this.accountId = source.getAccountId();
        this.username = source.getUsername();
        this.password = source.getPassword();
        this.permissions = source.getPermissions();
        this.accountStatus = source.getAccountStatus();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String roleType : this.permissions.getRoleTypes()) {
            if (!StringUtils.isNotBlank((Object)roleType)) continue;
            SimpleGrantedAuthority grantedAuthority = new SimpleGrantedAuthority(roleType);
            authorities.add(grantedAuthority);
        }
        return Collections.unmodifiableCollection(authorities);
    }

    public String getPassword() {
        return this.password;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountStatus.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this.accountStatus.isAccountNonLocked();
    }

    public boolean isCredentialsNonExpired() {
        return this.accountStatus.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this.accountStatus.isEnabled();
    }

    public boolean equals(Object object) {
        if (object instanceof CurrentUser) {
            CurrentUser that = (CurrentUser)object;
            return this.getUsername().equals(that.getUsername());
        }
        return false;
    }
}

