/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.selenium;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.crazyyak.dev.selenium.SeleniumBrowserException;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class SeleniumBrowser {
    private final WebDriver driver;
    private final long defaultTimeout;

    public SeleniumBrowser(WebDriver driver) throws Exception {
        this(driver, 500L, 10000L);
    }

    public SeleniumBrowser(WebDriver driver, long implicitlyWait, long defaultTimeout) throws Exception {
        this.defaultTimeout = defaultTimeout;
        this.driver = driver;
        this.driver.manage().timeouts().implicitlyWait(implicitlyWait, TimeUnit.MILLISECONDS);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public WebDriver.Window window() {
        return this.driver.manage().window();
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void get(String url) {
        this.driver.get(url);
    }

    public WebElement findElement(String key) {
        try {
            if (key.startsWith("#")) {
                String idKey = key.substring(1);
                List elements = this.driver.findElements(By.id((String)idKey));
                if (elements.size() > 1) {
                    String msg = String.format("More than one (%s) element was found for the id %s.", elements.size(), idKey);
                    throw new SeleniumBrowserException(msg);
                }
                return this.driver.findElement(By.id((String)idKey));
            }
            if (key.startsWith(".")) {
                String classKey = key.substring(1);
                return this.driver.findElement(By.className((String)classKey));
            }
            String msg = String.format("Cannot get element for key \"%s\".", key);
            throw new SeleniumBrowserException(msg);
        }
        catch (NoSuchElementException e) {
            String msg = String.format("Unable to locate the element \"%s\".", key);
            throw new SeleniumBrowserException(msg);
        }
    }

    public List<WebElement> findElements(String key) {
        if (key.startsWith("#")) {
            List elements = this.driver.findElements(By.id((String)(key = key.substring(1))));
            if (elements.size() > 1) {
                String msg = String.format("More than one (%s) element was found for the id %s.", elements.size(), key);
                throw new SeleniumBrowserException(msg);
            }
            return this.driver.findElements(By.id((String)key));
        }
        if (key.startsWith(".")) {
            key = key.substring(1);
            return this.driver.findElements(By.className((String)key));
        }
        String msg = String.format("Cannot get element for key %s.", key);
        throw new SeleniumBrowserException(msg);
    }

    public boolean isPresent(String elementName) {
        return !this.findElements(elementName).isEmpty();
    }

    public boolean isNotPresent(String elementName) {
        return this.findElements(elementName).isEmpty();
    }

    public void click(String elementName) throws Exception {
        this.click(elementName, this.defaultTimeout);
    }

    public void click(String elementName, long timeout) throws Exception {
        WebElement element = null;
        try {
            element = this.waitForElement(elementName, timeout);
            element.click();
        }
        catch (WebDriverException e) {
            throw new SeleniumBrowserException(e);
        }
    }

    public void moveTo(String elementName) throws Exception {
        this.moveTo(elementName, this.defaultTimeout);
    }

    public void moveTo(String elementName, long timeout) throws Exception {
        try {
            WebElement element = this.waitForElement(elementName, timeout);
            new Actions(this.driver).moveToElement(element);
        }
        catch (WebDriverException e) {
            throw new SeleniumBrowserException(e);
        }
    }

    private Point getCenter(WebElement element) {
        Point location = element.getLocation();
        Dimension dimension = element.getSize();
        location.x += (int)((double)dimension.width / 2.0);
        location.y += (int)((double)dimension.height / 2.0);
        return location;
    }

    public void sendKeys(String elementName, CharSequence text) throws Exception {
        this.sendKeys(elementName, text, this.defaultTimeout);
    }

    public void sendKeys(String elementName, CharSequence text, long timeout) throws Exception {
        try {
            this.waitForElement(elementName, timeout).sendKeys(new CharSequence[]{text});
        }
        catch (WebDriverException e) {
            throw new SeleniumBrowserException(e);
        }
    }

    public String getText(String elementName) throws Exception {
        return this.getText(elementName, this.defaultTimeout);
    }

    public String getText(String elementName, long timeout) throws Exception {
        try {
            return this.waitForElement(elementName, timeout).getText();
        }
        catch (WebDriverException e) {
            throw new SeleniumBrowserException(e);
        }
    }

    public void quit() {
        this.driver.quit();
    }

    public WebElement waitForElement(String elementName) throws Exception {
        return this.waitForElement(elementName, this.defaultTimeout);
    }

    public WebElement waitForElement(String elementName, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        List<Object> elements = new ArrayList();
        while (System.currentTimeMillis() - start < timeout) {
            elements = this.findElements(elementName);
            if (elements.isEmpty()) {
                Thread.sleep(250L);
                continue;
            }
            if (!((WebElement)elements.get(0)).isDisplayed()) {
                Thread.sleep(250L);
                continue;
            }
            return (WebElement)elements.get(0);
        }
        if (elements.isEmpty()) {
            String msg = String.format("The element \"%s\" was not found after %s milliseconds.", elementName, timeout);
            throw new SeleniumBrowserException(msg);
        }
        String msg = String.format("The element \"%s\" was found but not displayed after %s milliseconds.", elementName, timeout);
        throw new SeleniumBrowserException(msg);
    }

    public void waitForNotElement(String elementName) throws Exception {
        this.waitForNotElement(elementName, this.defaultTimeout);
    }

    public void waitForNotElement(String elementName, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        List<Object> elements = new ArrayList();
        while (System.currentTimeMillis() - start < timeout) {
            elements = this.findElements(elementName);
            if (elements.isEmpty()) {
                return;
            }
            Thread.sleep(250L);
        }
        if (!elements.isEmpty()) {
            String msg = String.format("The element \"%s\" was found after %s milliseconds.", elementName, timeout);
            throw new SeleniumBrowserException(msg);
        }
    }

    public void waitForText(String elementName, String message) throws Exception {
        this.waitForText(elementName, message, this.defaultTimeout);
    }

    public void waitForText(String elementName, String message, long timeout) throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            String text = this.findElement(elementName).getText();
            if (text.equals(message)) {
                return;
            }
            Thread.sleep(250L);
        }
        String msg = String.format("The element \"%s\" did not have a value of \"%s\" after %s milliseconds.", elementName, message, timeout);
        throw new SeleniumBrowserException(msg);
    }

    public void acceptAlert() {
        Alert alert = this.driver.switchTo().alert();
        alert.accept();
    }
}

