/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils {
    public static String encodeUrl(String value) {
        try {
            return value == null ? null : URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException("Cannot decode string as UTF-8.", ex);
        }
    }

    public static String decodeUrl(String value) {
        try {
            return value == null ? null : URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException("Cannot decode string as UTF-8.", ex);
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        for (Cookie cookie : cookies = cookies != null ? cookies : new Cookie[]{}) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public static void setCookie(HttpServletResponse response, String name, Object value, int expiry) {
        String stringValue = value == null ? null : value.toString();
        Cookie cookie = new Cookie(name, stringValue);
        cookie.setMaxAge(expiry);
        response.addCookie(cookie);
    }

    public static String buildUrlFromReferrer(HttpServletRequest request, String uri) {
        return ServletUtils.buildUrlFromReferrer(request.getHeader("referer"), uri);
    }

    public static String buildUrlFromReferrer(String referer, String uri) {
        int pos;
        String url = "";
        int n = pos = referer == null ? -1 : referer.indexOf("//");
        if (pos >= 0 && (pos = referer.indexOf("/", pos + 2)) >= 0) {
            url = referer.substring(0, pos);
        }
        url = url + uri;
        return url;
    }

    public static String buildUrl(HttpServletRequest request, String uri) {
        String url = "";
        url = url + request.getScheme();
        url = url + "://";
        url = url + request.getServerName();
        url = url + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        url = url + uri;
        return url;
    }

    public static Long getLong(HttpServletRequest request, String propertyName) {
        String value = request.getParameter(propertyName);
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

