/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.servlet.template.decorators;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.crazyyak.dev.servlet.template.decorators.Anchor;
import org.crazyyak.dev.servlet.template.decorators.Decorator;

public class AnchorDecorator
implements Decorator {
    public static final String ANCHORS = "templateAnchors";
    public static final String ANCHORS_DISABLED = "templateAnchorsDisabled";

    @Override
    public String decorate(String data, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ArrayList<Anchor> anchors = new ArrayList<Anchor>();
        boolean searching = true;
        int posA = data.indexOf("<a name");
        while (searching) {
            if (posA == -1) {
                searching = false;
                continue;
            }
            int posB = data.indexOf(">", posA);
            if (posB == -1) {
                searching = false;
                continue;
            }
            String tag = data.substring(posA, posB);
            Anchor anchor = new Anchor(tag);
            anchors.add(anchor);
            posA = data.indexOf("<a name", posB);
        }
        request.setAttribute(ANCHORS, (Object)anchors.toArray(new Anchor[anchors.size()]));
        return data;
    }
}

