/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.webmvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.crazyyak.dev.common.ReflectUtils;
import org.crazyyak.dev.common.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;

@Order(value=0)
public abstract class YakSpringWebAppInitializer
implements WebApplicationInitializer {
    public abstract String getEnvironmentPropertyName(ServletContext var1, WebApplicationContext var2);

    protected abstract String getProfilesPropertyName(ServletContext var1, WebApplicationContext var2);

    protected abstract Class<?>[] getSpringConfigClasses(ServletContext var1, WebApplicationContext var2);

    public void onStartup(ServletContext servletContext) throws ServletException {
        WebApplicationContext appContext = this.createWebApplicationContext(servletContext);
        this.addListeners(servletContext, appContext);
        this.addFilters(servletContext, appContext);
        this.addServlets(servletContext, appContext);
    }

    protected void addFilters(ServletContext servletContext, WebApplicationContext appContext) {
        this.addSpringSecurityFilter(servletContext, appContext);
    }

    protected void addListeners(ServletContext servletContext, WebApplicationContext appContext) {
        servletContext.addListener((EventListener)new ContextLoaderListener(appContext));
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext appContext = new AnnotationConfigWebApplicationContext();
        Class[] configClasses = this.getSpringConfigClasses(servletContext, (WebApplicationContext)appContext);
        if (configClasses != null) {
            appContext.register(configClasses);
        }
        String[] profiles = this.getSpringProfiles(servletContext, (WebApplicationContext)appContext);
        appContext.getEnvironment().setActiveProfiles(profiles);
        appContext.setServletContext(servletContext);
        appContext.refresh();
        return appContext;
    }

    protected void addSpringSecurityFilter(ServletContext servletContext, WebApplicationContext appContext) {
        FilterRegistration.Dynamic securityFilter = servletContext.addFilter("springSecurityFilterChain", DelegatingFilterProxy.class);
        securityFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    protected void addServlets(ServletContext servletContext, WebApplicationContext appContext) {
        this.addDispatcherServlet(servletContext, appContext);
        this.addJspfServlet(servletContext, appContext);
        this.registerStaticResourceUrlPatterns(servletContext, appContext);
    }

    protected void registerStaticResourceUrlPatterns(ServletContext servletContext, WebApplicationContext appContext) {
        for (String urlPattern : this.getStaticResourceUrlPatterns()) {
            urlPattern = "*." + urlPattern;
            servletContext.getServletRegistration("default").addMapping(new String[]{urlPattern});
        }
    }

    protected Collection<String> getStaticResourceUrlPatterns() {
        return Arrays.asList("html", "jpg", "png", "gif", "bmp", "css", "js", "ico", "pdf", "txt");
    }

    protected void addDispatcherServlet(ServletContext servletContext, WebApplicationContext appContext) {
        ServletRegistration.Dynamic servlet = servletContext.addServlet("dispatcherServlet", (Servlet)new DispatcherServlet(appContext));
        servlet.addMapping(new String[]{"/"});
        servlet.setLoadOnStartup(1);
    }

    protected void addJspfServlet(ServletContext servletContext, WebApplicationContext appContext) {
        servletContext.getServletRegistration("jsp").addMapping(new String[]{"*.jspf"});
    }

    protected String[] getSpringProfiles(ServletContext servletContext, WebApplicationContext appContext) {
        String environmentName = System.getProperty(this.getEnvironmentPropertyName(servletContext, appContext), "null");
        String envProfileName = "env-" + environmentName;
        String defaultProfiles = StringUtils.concat((String)",", (String[])new String[]{"main", "live", envProfileName});
        String profilesString = System.getProperty(this.getProfilesPropertyName(servletContext, appContext), defaultProfiles);
        ArrayList<String> profiles = new ArrayList<String>();
        for (String profile : profilesString.split(",")) {
            profiles.add(profile.trim());
        }
        return (String[])ReflectUtils.toArray(String.class, profiles);
    }
}

