/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.webmvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.dev.common.DateUtils;
import org.crazyyak.dev.jackson.YakJacksonObjectMapper;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.springsecurity3.dialect.SpringSecurityDialect;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

@Configuration
public class MvcSpringConfig
extends WebMvcConfigurationSupport {
    public static final Log log = LogFactory.getLog(MvcSpringConfig.class);
    private static final String MESSAGE_SOURCE = "/WEB-INF/i18n/messages";
    private ContentNegotiationManager contentNegotiationManager;

    public MvcSpringConfig() {
        log.debug((Object)("Created " + ((Object)((Object)this)).getClass().getName()));
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.jacksonConverter(this.yakJacksonObjectMapper()));
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        super.configureMessageConverters(converters);
    }

    @Bean
    public YakJacksonObjectMapper yakJacksonObjectMapper() {
        return new YakJacksonObjectMapper();
    }

    public ContentNegotiationManager mvcContentNegotiationManager() {
        if (this.contentNegotiationManager == null) {
            this.contentNegotiationManager = new ContentNegotiationManager(new ContentNegotiationStrategy[]{new HeaderContentNegotiationStrategy()});
        }
        return this.contentNegotiationManager;
    }

    @Bean
    public MappingJackson2HttpMessageConverter jacksonConverter(YakJacksonObjectMapper yakJacksonObjectMapper) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "json"), new MediaType("application", "*+json"), new MediaType("application", "json", Charset.forName("UTF-8")), new MediaType("application", "*+json", Charset.forName("UTF-8"))));
        converter.setObjectMapper((ObjectMapper)yakJacksonObjectMapper);
        return converter;
    }

    protected void addFormatters(FormatterRegistry registry) {
        registry.addFormatterForFieldType(LocalDate.class, (Formatter)new Formatter<LocalDate>(){

            public LocalDate parse(String text, Locale locale) throws ParseException {
                return DateUtils.toLocalDate((String)text);
            }

            public String print(LocalDate object, Locale locale) {
                return object == null ? null : object.toString();
            }
        });
        registry.addFormatterForFieldType(LocalTime.class, (Formatter)new Formatter<LocalTime>(){

            public LocalTime parse(String text, Locale locale) throws ParseException {
                return DateUtils.toLocalTime((String)text);
            }

            public String print(LocalTime object, Locale locale) {
                return object == null ? null : object.toString();
            }
        });
        registry.addFormatterForFieldType(LocalDateTime.class, (Formatter)new Formatter<LocalDateTime>(){

            public LocalDateTime parse(String text, Locale locale) throws ParseException {
                return DateUtils.toLocalDateTime((String)text);
            }

            public String print(LocalDateTime object, Locale locale) {
                return object == null ? null : object.toString();
            }
        });
        registry.addFormatterForFieldType(DateTime.class, (Formatter)new Formatter<DateTime>(){

            public DateTime parse(String text, Locale locale) throws ParseException {
                return DateUtils.toDateTime((String)text);
            }

            public String print(DateTime object, Locale locale) {
                return object == null ? null : object.toString();
            }
        });
    }

    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping requestMappingHandlerMapping = super.requestMappingHandlerMapping();
        requestMappingHandlerMapping.setUseSuffixPatternMatch(false);
        requestMappingHandlerMapping.setUseTrailingSlashMatch(false);
        return requestMappingHandlerMapping;
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    @Bean(name={"messageSource"})
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename(MESSAGE_SOURCE);
        messageSource.setCacheSeconds(0);
        return messageSource;
    }

    public Validator getValidator() {
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        validator.setValidationMessageSource(this.messageSource());
        return validator;
    }

    @Bean
    public TemplateResolver templateResolver() {
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver();
        templateResolver.setPrefix("");
        templateResolver.setSuffix("");
        templateResolver.setTemplateMode("HTML5");
        templateResolver.setCacheable(false);
        return templateResolver;
    }

    @Bean
    public SpringTemplateEngine templateEngine() {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver());
        templateEngine.addDialect((IDialect)new SpringSecurityDialect());
        return templateEngine;
    }

    private class CustomTemplateResolver
    extends TemplateResolver {
        private CustomTemplateResolver() {
        }
    }
}

