package org.crazyyak.lib.couchace;

import com.couchace.core.api.json.CouchJsonException;
import com.couchace.core.api.response.TextDocument;
import com.couchace.jackson.JacksonCouchJsonStrategy;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

public class YakJacksonCouchJsonStrategy extends JacksonCouchJsonStrategy {

  public YakJacksonCouchJsonStrategy() {
    initialize();
  }

  public YakJacksonCouchJsonStrategy(Module... modules) {
    super(modules);
    initialize();
  }

  public YakJacksonCouchJsonStrategy(ObjectMapper objectMapper) {
    super(objectMapper);
    initialize();
  }

  private void initialize() {
    this.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
  }

  @Override
  public TextDocument readTextDocument(String json) throws CouchJsonException {
    JsonFactory jsonFactory = getObjectMapper().getFactory();
    try {
      try (JsonParser parser = jsonFactory.createParser(json)) {
        if (parser.nextToken() != JsonToken.START_OBJECT) {
          throw new IOException("Expected response JSON to start with an Object: " + parser.getCurrentToken());
        }

        String documentId = null;
        String revision = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
          String name = parser.getCurrentName();
          parser.nextToken();
          if ("_id".equals(name)) {
            documentId = parser.getText();
          } else if ("_rev".equals(name)) {
            revision = parser.getText();
          }

          if (documentId != null && revision != null) {
            // We have what we needed, stop parsing.
            break;
          }
        }

        return new TextDocument(documentId, revision, null, json);
      }
    } catch (IOException e) {
      throw new CouchJsonException(e);
    }
  }
}
