/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.couchace;

import com.couchace.core.api.CouchDatabase;
import com.couchace.core.api.CouchException;
import com.couchace.core.api.CouchServer;
import com.couchace.core.api.meta.AnnotationMetaBuilder;
import com.couchace.core.api.meta.EntityMeta;
import com.couchace.core.api.query.CouchViewQuery;
import com.couchace.core.api.request.GetEntityRequest;
import com.couchace.core.api.response.GetEntityResponse;
import com.couchace.core.api.response.HeadResponse;
import com.couchace.core.api.response.WriteResponse;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.crazyyak.dev.common.ReflectUtils;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;

public abstract class DefaultCouchStore<T> {
    private final Class<T> entityType;
    protected final CouchDatabase database;

    public abstract String getDesignName();

    public DefaultCouchStore(CouchServer couchServer, String databaseName, Class<T> entityType) {
        this.entityType = (Class)ExceptionUtils.assertNotNull(entityType, (String)"entityType");
        ExceptionUtils.assertNotNull((Object)databaseName, (String)"databaseName");
        this.database = couchServer.database(databaseName);
        if (this.database == null || !this.database.exists()) {
            String msg = String.format("The database \"%s\" does not exist.", databaseName);
            throw new IllegalArgumentException(msg);
        }
    }

    public WriteResponse update(T entity) {
        WriteResponse response = this.database.put().entity(entity).execute();
        if (!response.isCreated()) {
            String msg = String.format("Unexpected DB response %s: %s\n", response.getStatusCode(), response.getErrorContent());
            throw new CouchException(response.getStatusCode(), msg);
        }
        this.injectVersion(entity, response);
        return response;
    }

    public T getByDocumentId(String documentId) {
        GetEntityRequest request = this.database.get().entity(this.entityType, documentId);
        GetEntityResponse response = request.execute();
        return (T)(response.isEmpty() ? null : response.getFirstEntity());
    }

    public HeadResponse headByDocumentId(String documentId) {
        return this.database.head().id(documentId).execute();
    }

    public WriteResponse delete(T entity) {
        WriteResponse deleteResponse = this.database.delete().entity(entity).execute();
        return this.validateDelete(deleteResponse);
    }

    public WriteResponse deleteByDocumentId(String documentId, String revision) {
        WriteResponse deleteResponse = this.database.delete().document(documentId, revision).execute();
        return this.validateDelete(deleteResponse);
    }

    private WriteResponse validateDelete(WriteResponse deleteResponse) {
        if (!deleteResponse.isOk()) {
            String msg = String.format("Unexpected DB response %s: %s\n", deleteResponse.getStatusCode(), deleteResponse.getErrorContent());
            throw new CouchException(deleteResponse.getStatusCode(), msg);
        }
        return deleteResponse;
    }

    public WriteResponse create(T entity) {
        WriteResponse putResponse = this.database.put().entity(entity).execute();
        if (!putResponse.isCreated()) {
            String msg = String.format("Unexpected DB response %s: %s\n", putResponse.getStatusCode(), putResponse.getErrorContent());
            throw new CouchException(putResponse.getStatusCode(), msg);
        }
        this.injectVersion(entity, putResponse);
        return putResponse;
    }

    protected List<T> getEntities(String viewName, String ... keyValues) {
        return this.getEntities(viewName, (Object[])keyValues);
    }

    protected List<T> getEntities(String viewName, Object[] keyValues) {
        return this.getEntities(viewName, Arrays.asList(keyValues));
    }

    protected List<T> getEntities(String viewName, Collection<?> keyValues) {
        GetEntityResponse<T> response = this.getEntityResponse(viewName, keyValues);
        return response.getEntityList();
    }

    protected GetEntityResponse<T> getEntityResponse(String viewName, Collection<?> keyValues) {
        CouchViewQuery couchViewQuery = CouchViewQuery.builder((String)this.getDesignName(), (String)viewName).key(keyValues.toArray()).includeDocs(true).build();
        GetEntityResponse response = this.database.get().entity(this.entityType, couchViewQuery).execute();
        if (response.isNotFound()) {
            String msg = String.format("The view \"_design/%s:%s\" does not exist.", this.getDesignName(), viewName);
            throw new CouchException(response.getStatusCode(), msg);
        }
        if (!response.isOk()) {
            throw new CouchException(response.getStatusCode());
        }
        return response;
    }

    protected void injectVersion(T entity, WriteResponse response) {
        String version = response.getDocumentRevision();
        EntityMeta meta = new AnnotationMetaBuilder().buildEntityMeta(this.entityType);
        String property = meta.getRevisionName();
        Field field = ReflectUtils.getField(entity.getClass(), (String)property);
        ReflectUtils.setPropertyValue(entity, (Field)field, (Object)version);
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public CouchDatabase getDatabase() {
        return this.database;
    }
}

