/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.couchace.sequence;

import com.couchace.annotations.CouchEntity;
import com.couchace.annotations.CouchId;
import com.couchace.annotations.CouchRevision;
import com.couchace.core.api.CouchException;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.crazyyak.lib.couchace.sequence.SequenceType;

@CouchEntity(value="sequence")
public class Sequence {
    private String revision;
    private String sequenceId;
    private String lastValue = "";

    @JsonCreator
    private Sequence(@JacksonInject(value="sequenceId") String sequenceId, @JacksonInject(value="revision") String revision, @JsonProperty(value="lastValue") String lastValue) {
        this.sequenceId = sequenceId;
        this.revision = revision;
        this.lastValue = lastValue;
    }

    public Sequence(SequenceType sequenceType, String firstValue) {
        this.sequenceId = ((SequenceType)ExceptionUtils.assertNotNull((Object)sequenceType, (String)"sequenceType")).getId();
        this.lastValue = (String)ExceptionUtils.assertNotNull((Object)firstValue, (String)"firstValue");
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    @CouchId
    public String getSequenceId() {
        return this.sequenceId;
    }

    public String getLastValue() {
        return String.valueOf(this.lastValue);
    }

    public String incrementValue() {
        char[] charValue = this.lastValue.toCharArray();
        for (int i = 0; i < charValue.length; ++i) {
            charValue[i] = Sequence.incrementChar(charValue[i]);
            if (charValue[i] == '0') continue;
            this.lastValue = String.valueOf(charValue);
            return this.lastValue;
        }
        this.lastValue = String.valueOf(charValue) + '0';
        return this.lastValue;
    }

    public static char incrementChar(char chr) {
        if (chr >= '0' && chr < '9') {
            chr = (char)(chr + '\u0001');
            return chr;
        }
        if (chr == '9') {
            return 'a';
        }
        if (chr >= 'a' && chr < 'z') {
            chr = (char)(chr + '\u0001');
            return chr;
        }
        if (chr == 'z') {
            return 'A';
        }
        if (chr >= 'A' && chr < 'Z') {
            chr = (char)(chr + '\u0001');
            return chr;
        }
        if (chr == 'Z') {
            return '0';
        }
        String msg = String.format("Cannot increment char for %s.", Character.valueOf(chr));
        throw new CouchException(-1, msg);
    }
}

