/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.couchace;

import com.couchace.core.api.CouchDatabase;
import com.couchace.core.api.CouchException;
import com.couchace.core.api.CouchServer;
import com.couchace.core.api.meta.AnnotationCouchMetaBuilder;
import com.couchace.core.api.meta.CouchEntityMeta;
import com.couchace.core.api.query.CouchViewQuery;
import com.couchace.core.api.request.GetEntityRequest;
import com.couchace.core.api.response.GetEntityResponse;
import com.couchace.core.api.response.HeadResponse;
import com.couchace.core.api.response.WriteResponse;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.crazyyak.dev.common.ReflectUtils;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;

public abstract class DefaultCouchStore<T> {
    private final Class<T> entityType;
    private final CouchServer couchServer;
    private final Map<String, CouchDatabase> databaseMap = new HashMap<String, CouchDatabase>();
    private final Map<String, Long> databaseAccessMap = new HashMap<String, Long>();

    public abstract String getDesignName();

    public abstract String getDatabaseName();

    public DefaultCouchStore(CouchServer couchServer, Class<T> entityType) {
        this.couchServer = (CouchServer)ExceptionUtils.assertNotNull((Object)couchServer, (String)"couchServer");
        this.entityType = (Class)ExceptionUtils.assertNotNull(entityType, (String)"entityType");
        ExceptionUtils.assertNotNull((Object)this.getDatabaseName(), (String)"databaseName");
    }

    public CouchDatabase getDatabase() {
        CouchDatabase database;
        String databaseName = this.getDatabaseName();
        if (!this.databaseMap.containsKey(databaseName)) {
            database = this.couchServer.database(databaseName);
            if (!database.exists()) {
                String msg = String.format("The database \"%s\" does not exist.", databaseName);
                throw new IllegalArgumentException(msg);
            }
            this.databaseMap.put(databaseName, database);
        }
        this.databaseAccessMap.put(databaseName, System.currentTimeMillis());
        database = this.databaseMap.get(databaseName);
        this.expireCachedDatabases();
        return database;
    }

    public void expireCachedDatabases() {
        for (String dbName : this.databaseAccessMap.keySet()) {
            long accessedAt = this.databaseAccessMap.get(dbName);
            if (System.currentTimeMillis() - accessedAt <= 60000L) continue;
            this.databaseMap.remove(dbName);
            this.databaseAccessMap.remove(dbName);
        }
    }

    public CouchServer getCouchServer() {
        return this.couchServer;
    }

    public Map<String, CouchDatabase> getDatabaseMap() {
        return Collections.unmodifiableMap(this.databaseMap);
    }

    public Map<String, Long> getDatabaseAccessMap() {
        return Collections.unmodifiableMap(this.databaseAccessMap);
    }

    public WriteResponse update(T entity) {
        WriteResponse response = this.getDatabase().put().entity(entity).execute();
        if (!response.isCreated()) {
            String msg = String.format("Unexpected DB response %s: %s\n", response.getHttpStatus(), response.getErrorContent());
            throw new CouchException(response.getHttpStatus(), msg);
        }
        this.injectVersion(entity, response);
        return response;
    }

    public T getByDocumentId(String documentId) {
        GetEntityRequest request = this.getDatabase().get().entity(this.entityType, documentId);
        GetEntityResponse response = request.execute();
        return (T)(response.isEmpty() ? null : response.getFirstEntity());
    }

    public HeadResponse headByDocumentId(String documentId) {
        return this.getDatabase().head().id(documentId).execute();
    }

    public WriteResponse delete(T entity) {
        WriteResponse deleteResponse = this.getDatabase().delete().entity(entity).execute();
        return this.validateDelete(deleteResponse);
    }

    public WriteResponse deleteByDocumentId(String documentId, String revision) {
        WriteResponse deleteResponse = this.getDatabase().delete().document(documentId, revision).execute();
        return this.validateDelete(deleteResponse);
    }

    private WriteResponse validateDelete(WriteResponse deleteResponse) {
        if (!deleteResponse.isOk()) {
            String msg = String.format("Unexpected DB response %s: %s\n", deleteResponse.getHttpStatus(), deleteResponse.getErrorContent());
            throw new CouchException(deleteResponse.getHttpStatus(), msg);
        }
        return deleteResponse;
    }

    public WriteResponse create(T entity) {
        WriteResponse putResponse = this.getDatabase().put().entity(entity).execute();
        if (!putResponse.isCreated()) {
            String msg = String.format("Unexpected DB response %s: %s\n", putResponse.getHttpStatus(), putResponse.getErrorContent());
            throw new CouchException(putResponse.getHttpStatus(), msg);
        }
        this.injectVersion(entity, putResponse);
        return putResponse;
    }

    protected List<T> getEntities(String viewName, String ... keyValues) {
        return this.getEntities(viewName, (Object[])keyValues);
    }

    protected List<T> getEntities(String viewName, Object[] keyValues) {
        return this.getEntities(viewName, Arrays.asList(keyValues));
    }

    protected List<T> getEntities(String viewName, Collection<?> keyValues) {
        GetEntityResponse<T> response = this.getEntityResponse(viewName, keyValues);
        return response.getEntityList();
    }

    protected GetEntityResponse<T> getEntityResponse(String viewName, Collection<?> keyValues) {
        CouchViewQuery couchViewQuery = CouchViewQuery.builder((String)this.getDesignName(), (String)viewName).key(keyValues.toArray()).includeDocs(true).build();
        GetEntityResponse response = this.getDatabase().get().entity(this.entityType, couchViewQuery).execute();
        if (response.isNotFound()) {
            String msg = String.format("The view \"_design/%s:%s\" does not exist.", this.getDesignName(), viewName);
            throw new CouchException(response.getHttpStatus(), msg);
        }
        if (!response.isOk()) {
            throw new CouchException(response.getHttpStatus());
        }
        return response;
    }

    protected void injectVersion(T entity, WriteResponse response) {
        String version = response.getDocumentRevision();
        CouchEntityMeta meta = new AnnotationCouchMetaBuilder().buildEntityMeta(this.entityType);
        String property = meta.getRevisionName();
        Field field = ReflectUtils.getField(entity.getClass(), (String)property);
        ReflectUtils.setPropertyValue(entity, (Field)field, (Object)version);
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }
}

