/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.couchace.sequence;

import com.couchace.core.api.CouchServer;
import com.couchace.core.api.response.WriteResponse;
import org.crazyyak.lib.couchace.DefaultCouchStore;
import org.crazyyak.lib.couchace.sequence.Sequence;
import org.crazyyak.lib.couchace.sequence.SequenceType;

public class SequenceStore
extends DefaultCouchStore<Sequence> {
    public static final String SEQUENCE_DESIGN_NAME = "sequence";
    private final String databaseName;
    public static final String designDocuments = "{\n   \"_id\": \"_design/sequence\",\n   \"_rev\": \"1-1889459c85063b18661870eae618733c\",\n   \"language\": \"javascript\",\n   \"views\": {\n       \"all\": {\n           \"map\": \"\\nfunction(doc) {\\n  if (doc.entityType == 'sequence') {\\n    emit(doc._id, null);\\n  }\\n}\"\n       }\n   }\n}";

    public SequenceStore(CouchServer couchServer, String databaseName) {
        super(couchServer, Sequence.class);
        this.databaseName = databaseName;
    }

    @Override
    public String getDesignName() {
        return SEQUENCE_DESIGN_NAME;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getNextValue(SequenceType type) {
        Sequence sequence = (Sequence)super.getByDocumentId(type.getId());
        if (sequence == null) {
            return this.create(type);
        }
        String nextValue = sequence.incrementValue();
        WriteResponse writeResponse = super.update(sequence);
        if (writeResponse.isCreated()) {
            return nextValue;
        }
        return this.getNextValue(type);
    }

    private String create(SequenceType type) {
        Sequence sequence = new Sequence(type, "1");
        WriteResponse response = super.create(sequence);
        if (response.isCreated()) {
            return sequence.getLastValue();
        }
        return this.getNextValue(type);
    }
}

