/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.couchace.support;

import com.couchace.core.api.CouchDatabase;
import com.couchace.core.api.CouchException;
import com.couchace.core.api.response.GetDocumentResponse;
import com.couchace.core.api.response.WriteResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.dev.common.IoUtils;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.common.id.IdGenerator;

public abstract class CouchUtils {
    private static final Log log = LogFactory.getLog(CouchUtils.class);

    private CouchUtils() {
    }

    public static void compactAndCleanAll(CouchDatabase couchDatabase, Collection<String> designNames) {
        CouchUtils.compactDatabase(couchDatabase);
        CouchUtils.compactDesigns(couchDatabase, designNames);
        CouchUtils.cleanupViews(couchDatabase);
    }

    public static void compactDatabase(CouchDatabase couchDatabase) {
        WriteResponse response = couchDatabase.post().database("_compact").execute();
        String msg = String.format("Compaction of database failed: %s %s", response.getHttpStatus().getCode(), response.getHttpStatus().getReason());
        CouchUtils.validateResponse(response, msg);
    }

    public static void compactDesigns(CouchDatabase couchDatabase, Collection<String> designNames) {
        for (String designName : designNames) {
            WriteResponse response = couchDatabase.post().database("_compact/" + designName).execute();
            String msg = String.format("Compaction of %s failed: %s %s", designName, response.getHttpStatus().getCode(), response.getHttpStatus().getCode());
            CouchUtils.validateResponse(response, msg);
        }
    }

    public static void cleanupViews(CouchDatabase couchDatabase) {
        WriteResponse response = couchDatabase.post().database("_view_cleanup").execute();
        String msg = String.format("View cleanup failed: %s %s", response.getHttpStatus().getCode(), response.getHttpStatus().getCode());
        CouchUtils.validateResponse(response, msg);
    }

    public static boolean createDatabase(CouchDatabase database) {
        return CouchUtils.createDatabase(database, null, new ArrayList<String>());
    }

    public static boolean createDatabase(CouchDatabase database, IdGenerator idGenerator, String ... documentPaths) {
        return CouchUtils.createDatabase(database, idGenerator, Arrays.asList(documentPaths));
    }

    public static boolean createDatabase(CouchDatabase database, IdGenerator idGenerator, Collection<String> documentPaths) {
        if (database.exists()) {
            log.info((Object)("The database " + database.getDatabaseName() + " already exists."));
            return false;
        }
        log.warn((Object)("Creating the database " + database.getDatabaseName()));
        WriteResponse response = database.createDatabase();
        if (!response.isCreated()) {
            String msg = String.format("Unable to create database: %s %s", response.getHttpStatus().getCode(), response.getHttpStatus().getReason());
            throw ApiException.internalServerError((String)msg, (String[])new String[0]);
        }
        for (String documentPath : documentPaths) {
            try {
                log.warn((Object)("Creating the document " + documentPath));
                String json = IoUtils.toString((InputStream)CouchUtils.class.getResourceAsStream(documentPath));
                String hacked = json.replace(" ", "");
                if (!hacked.contains("\"_id\":\"")) {
                    response = database.put().document(idGenerator.newId(), json).execute();
                } else {
                    int posA = hacked.indexOf("\"_id\":\"") + 7;
                    int posB = hacked.indexOf("\"", posA);
                    String id = hacked.substring(posA, posB);
                    response = database.put().document(id, json).execute();
                }
                if (response.isCreated()) continue;
                String msg = String.format("Unable to put document %s: %s %s", documentPath, response.getHttpStatus().getCode(), response.getHttpStatus().getReason());
                throw ApiException.internalServerError((String)msg, (String[])new String[0]);
            }
            catch (IOException ex) {
                throw ApiException.internalServerError((String)"Unexpected exception reading couch document.", (Throwable)ex, (String[])new String[0]);
            }
        }
        return true;
    }

    public static void validateDesign(CouchDatabase database, Collection<String> designNames, String filePath, String fileSuffix) {
        for (String designName : designNames) {
            try {
                String fullPath = filePath + designName + fileSuffix;
                InputStream in = CouchUtils.class.getResourceAsStream(fullPath);
                if (in == null) {
                    String msg = String.format("The resource \"%s\" was not found.", fullPath);
                    throw new NullPointerException(msg);
                }
                String expectedDoc = IoUtils.toString((InputStream)in);
                String docId = "_design/" + designName;
                GetDocumentResponse getResponse = database.get().document(docId).execute();
                if (getResponse.isNotFound()) {
                    WriteResponse writeResponse = database.put().design(designName, expectedDoc).execute();
                    if (writeResponse.isCreated()) continue;
                    throw new CouchException(writeResponse.getHttpStatus(), "Unsuccessful in creating design document " + designName);
                }
                String existingDoc = getResponse.getFirstDocument().getContent();
                if ((existingDoc = CouchUtils.normalizeDoc(existingDoc)).equals(expectedDoc = CouchUtils.normalizeDoc(expectedDoc))) continue;
                String msg = String.format("The two documents (%s) do not match:\n%s\n%s", designName, existingDoc, expectedDoc);
                throw new CouchException(-1, msg);
            }
            catch (Throwable ex) {
                String msg = String.format("Exception validating design of %s.", designName);
                throw new CouchException(-1, msg, ex);
            }
        }
    }

    private static void validateResponse(WriteResponse response, String msg) {
        int code = response.getHttpStatus().getCode();
        if (code < 200 || code >= 300) {
            throw new CouchException(response.getHttpStatus(), msg);
        }
    }

    private static String normalizeDoc(String doc) {
        doc = doc.replaceAll(" ", "");
        doc = doc.replaceAll("\n", "");
        doc = doc.replaceAll("\r", "");
        doc = doc.replaceAll("\t", "");
        doc = CouchUtils.strip("_rev", doc);
        doc = CouchUtils.strip("language", doc);
        return doc;
    }

    private static String strip(String word, String text) {
        String key = "\"" + word + "\":\"";
        int posA = text.indexOf(key);
        if (posA < 0) {
            return text;
        }
        int posB = text.indexOf("\"", posA + key.length());
        if (posB < 0) {
            return text;
        }
        String left = text.substring(0, posA);
        String right = text.substring(posB + 1);
        if (left.endsWith(",") && right.startsWith(",")) {
            right = right.substring(1);
        }
        String retVal = left + right;
        return retVal.trim();
    }
}

