package org.crazyyak.lib.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.*;
import javax.ws.rs.ext.*;
import org.crazyyak.dev.common.DateUtils;

@Provider
public class JavaTimeParamConverterProvider implements ParamConverterProvider {

  @Override
  public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {

    if (LocalDate.class.equals(rawType)) {
          // noinspection unchecked
          return (ParamConverter<T>)new LocalDateParamConverter();

        } else if (LocalTime.class.equals(rawType)) {
          // noinspection unchecked
          return (ParamConverter<T>)new LocalTimeParamConverter();

        } else if (LocalDateTime.class.equals(rawType)) {
          // noinspection unchecked
          return (ParamConverter<T>)new LocalDateTimeParamConverter();

        } else if (ZonedDateTime.class.equals(rawType)) {
          // noinspection unchecked
          return (ParamConverter<T>)new ZonedDateTimeParamConverter();

        }

        return null;
  }

  private static class LocalDateParamConverter implements ParamConverter<LocalDate> {
    @Override public LocalDate fromString(String value) { return (value == null) ? null : DateUtils.toLocalDate(value); }
    @Override public String toString(LocalDate value) { return (value == null) ? "" : value.toString(); }
  }
  public class LocalDateTimeParamConverter implements ParamConverter<LocalDateTime> {
    @Override public LocalDateTime fromString(String value) { return (value == null) ? null : DateUtils.toLocalDateTime(value); }
    @Override public String toString(LocalDateTime value) { return (value == null) ? "" : value.toString(); }
  }
  public class LocalTimeParamConverter implements ParamConverter<LocalTime> {
    @Override public LocalTime fromString(String value) { return (value == null) ? null : DateUtils.toLocalTime(value); }
    @Override public String toString(LocalTime value) { return (value == null) ? "" : value.toString(); }
  }
  public class ZonedDateTimeParamConverter implements ParamConverter<ZonedDateTime> {
    @Override public ZonedDateTime fromString(String value) { return (value == null) ? null : DateUtils.toDateTime(value); }
    @Override public String toString(ZonedDateTime value) { return (value == null) ? "" : value.toString(); }
  }
}
