/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.crazyyak.dev.common.DateUtils;

@Provider
public class JavaTimeParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (LocalDate.class.equals(rawType)) {
            return new LocalDateParamConverter();
        }
        if (LocalTime.class.equals(rawType)) {
            return new LocalTimeParamConverter();
        }
        if (LocalDateTime.class.equals(rawType)) {
            return new LocalDateTimeParamConverter();
        }
        if (ZonedDateTime.class.equals(rawType)) {
            return new ZonedDateTimeParamConverter();
        }
        return null;
    }

    public class ZonedDateTimeParamConverter
    implements ParamConverter<ZonedDateTime> {
        public ZonedDateTime fromString(String value) {
            return value == null ? null : DateUtils.toDateTime((String)value);
        }

        public String toString(ZonedDateTime value) {
            return value == null ? "" : value.toString();
        }
    }

    public class LocalTimeParamConverter
    implements ParamConverter<LocalTime> {
        public LocalTime fromString(String value) {
            return value == null ? null : DateUtils.toLocalTime((String)value);
        }

        public String toString(LocalTime value) {
            return value == null ? "" : value.toString();
        }
    }

    public class LocalDateTimeParamConverter
    implements ParamConverter<LocalDateTime> {
        public LocalDateTime fromString(String value) {
            return value == null ? null : DateUtils.toLocalDateTime((String)value);
        }

        public String toString(LocalDateTime value) {
            return value == null ? "" : value.toString();
        }
    }

    private static class LocalDateParamConverter
    implements ParamConverter<LocalDate> {
        private LocalDateParamConverter() {
        }

        public LocalDate fromString(String value) {
            return value == null ? null : DateUtils.toLocalDate((String)value);
        }

        public String toString(LocalDate value) {
            return value == null ? "" : value.toString();
        }
    }
}

