/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.joda;

import java.util.Calendar;
import java.util.Date;
import org.crazyyak.dev.common.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class JodaDateUtilsFactory {
    private final DateTimeZone defaultTimeZone;

    public JodaDateUtilsFactory(DateTimeZone defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    public LocalTime currentTime() {
        return new LocalTime(this.defaultTimeZone);
    }

    public LocalDateTime currentDateTime() {
        return new LocalDateTime(this.defaultTimeZone);
    }

    public LocalDate currentDate() {
        return new LocalDate(this.defaultTimeZone);
    }

    public LocalDateTime midnightToday() {
        return new LocalDate(this.defaultTimeZone).toLocalDateTime(LocalTime.MIDNIGHT);
    }

    public LocalDate toLocalDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        if (date instanceof String) {
            return this.toLocalDate((String)date);
        }
        if (date instanceof Long) {
            return this.toLocalDate((Long)date);
        }
        if (date instanceof Date) {
            return this.toLocalDate((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toLocalDate((Calendar)date);
        }
        if (date instanceof LocalDateTime) {
            return this.toLocalDate((LocalDateTime)date);
        }
        if (date instanceof DateTime) {
            return this.toLocalDate((DateTime)date);
        }
        String msg = String.format("Cannot convert objects of type %s to LocalDate.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public LocalDate toLocalDate(String date) {
        if (StringUtils.isBlank((Object)date)) {
            return null;
        }
        if ((date = date.replace('/', '-')).contains(" ")) {
            date = date.substring(0, date.indexOf(32));
            return new LocalDate((Object)date, this.defaultTimeZone);
        }
        if (date.contains("T")) {
            date = date.substring(0, date.indexOf(84));
            return new LocalDate((Object)date, this.defaultTimeZone);
        }
        return new LocalDate((Object)date, this.defaultTimeZone);
    }

    public LocalDate toLocalDate(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            return new LocalDate(date, this.defaultTimeZone);
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    public LocalDate toLocalDate(Date date) {
        if (StringUtils.isBlank((Object)date)) {
            return null;
        }
        return new LocalDate((Object)date, this.defaultTimeZone);
    }

    public LocalDate toLocalDate(Calendar date) {
        if (StringUtils.isBlank((Object)date)) {
            return null;
        }
        return new LocalDate((Object)date, this.defaultTimeZone);
    }

    public LocalDate toLocalDate(LocalDateTime date) {
        if (StringUtils.isBlank((Object)date)) {
            return null;
        }
        return date.toLocalDate();
    }

    public LocalDate toLocalDate(DateTime date) {
        if (StringUtils.isBlank((Object)date)) {
            return null;
        }
        return date.toLocalDate();
    }

    public LocalDate toLocalDate(int year, int monthOfYear, int dayOfMonth) {
        return new LocalDate(year, monthOfYear, dayOfMonth);
    }

    public LocalTime toLocalTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalTime) {
            return (LocalTime)date;
        }
        if (date instanceof String) {
            return this.toLocalTime((String)date);
        }
        if (date instanceof Long) {
            return this.toLocalTime((Long)date);
        }
        if (date instanceof Date) {
            return this.toLocalTime((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toLocalTime((Calendar)date);
        }
        if (date instanceof LocalDateTime) {
            return this.toLocalTime((LocalDateTime)date);
        }
        if (date instanceof DateTime) {
            return this.toLocalTime((DateTime)date);
        }
        String msg = String.format("Cannot convert objects of type %s to LocalTime.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public LocalTime toLocalTime(String date) {
        if (date == null) {
            return null;
        }
        if (!(date = date.replace('/', '-')).contains("-")) {
            return new LocalTime((Object)date, this.defaultTimeZone);
        }
        if (date.contains(" ")) {
            date = date.replace(" ", "T");
            return new LocalDateTime((Object)date, this.defaultTimeZone).toLocalTime();
        }
        if (date.contains("T")) {
            return new LocalDateTime((Object)date, this.defaultTimeZone).toLocalTime();
        }
        return LocalTime.MIDNIGHT;
    }

    public LocalTime toLocalTime(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            return new LocalTime(date, this.defaultTimeZone);
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    public LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        return new LocalTime((Object)date, this.defaultTimeZone);
    }

    public LocalTime toLocalTime(Calendar date) {
        if (date == null) {
            return null;
        }
        return new LocalTime((Object)date, this.defaultTimeZone);
    }

    public LocalTime toLocalTime(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalTime();
    }

    public LocalTime toLocalTime(DateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalTime();
    }

    public LocalTime toLocalTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return new LocalTime(hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public LocalDateTime toLocalDateTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDateTime) {
            return (LocalDateTime)date;
        }
        if (date instanceof String) {
            return this.toLocalDateTime((String)date);
        }
        if (date instanceof Long) {
            return this.toLocalDateTime((Long)date);
        }
        if (date instanceof Date) {
            return this.toLocalDateTime((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toLocalDateTime((Calendar)date);
        }
        if (date instanceof LocalDate) {
            return this.toLocalDateTime((LocalDate)date);
        }
        if (date instanceof DateTime) {
            return this.toLocalDateTime((DateTime)date);
        }
        String msg = String.format("Cannot convert objects of type %s to LocalDateTime.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public LocalDateTime toLocalDateTime(String date) {
        if (date == null) {
            return null;
        }
        if ((date = date.replace('/', '-')).contains(" ")) {
            date = date.replace(" ", "T");
        } else if (!date.contains("T")) {
            date = date + "T" + LocalTime.MIDNIGHT;
        }
        return new LocalDateTime((Object)date, this.defaultTimeZone);
    }

    public LocalDateTime toLocalDateTime(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            return new LocalDateTime(date, this.defaultTimeZone);
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    public LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return new LocalDateTime((Object)date, this.defaultTimeZone);
    }

    public LocalDateTime toLocalDateTime(Calendar date) {
        if (date == null) {
            return null;
        }
        return new LocalDateTime((Object)date, this.defaultTimeZone);
    }

    public LocalDateTime toLocalDateTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.toLocalDateTime(LocalTime.MIDNIGHT);
    }

    public LocalDateTime toLocalDateTime(DateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalDateTime();
    }

    public LocalDateTime toLocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return new LocalDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public DateTime toDateTime(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        if (date instanceof String) {
            return this.toDateTime((String)date);
        }
        if (date instanceof Long) {
            return this.toDateTime((Long)date);
        }
        if (date instanceof LocalDate) {
            return this.toDateTime((LocalDate)date);
        }
        if (date instanceof LocalDateTime) {
            return this.toDateTime((LocalDateTime)date);
        }
        if (date instanceof Date) {
            return this.toDateTime((Date)date);
        }
        if (date instanceof Calendar) {
            return this.toDateTime((Calendar)date);
        }
        String msg = String.format("Cannot convert objects of type %s to DateTime.", date.getClass().getSimpleName());
        throw new IllegalArgumentException(msg);
    }

    public DateTime toDateTime(String date) {
        if (date == null) {
            return null;
        }
        if ((date = date.replace('/', '-')).contains(" ")) {
            date = date.replace(" ", "T");
            return new DateTime((Object)date, this.defaultTimeZone);
        }
        if (date.contains("T")) {
            return new DateTime((Object)date, this.defaultTimeZone);
        }
        return new LocalDate((Object)date, this.defaultTimeZone).toDateTime(LocalTime.MIDNIGHT);
    }

    public DateTime toDateTime(long date) {
        if (date == 0L) {
            return null;
        }
        if (date > 0L) {
            return new DateTime(date, this.defaultTimeZone);
        }
        throw new IllegalArgumentException("The value \"date\" must be greater than or equal to zero.");
    }

    public DateTime toDateTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.toDateTime(LocalTime.MIDNIGHT, this.defaultTimeZone);
    }

    public DateTime toDateTime(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toDateTime(this.defaultTimeZone);
    }

    public DateTime toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date.getTime(), this.defaultTimeZone);
    }

    public DateTime toDateTime(Calendar date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date.getTime().getTime(), this.defaultTimeZone);
    }

    public DateTime toDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }
}

