/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.joda.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

@Provider
public class JodaParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (LocalDate.class.equals(rawType)) {
            return new LocalDateParamConverter();
        }
        if (LocalTime.class.equals(rawType)) {
            return new LocalTimeParamConverter();
        }
        if (LocalDateTime.class.equals(rawType)) {
            return new LocalDateTimeParamConverter();
        }
        if (DateTime.class.equals(rawType)) {
            return new DateTimeParamConverter();
        }
        return null;
    }

    public static class DateTimeParamConverter
    implements ParamConverter<DateTime> {
        public DateTime fromString(String value) {
            return new DateTime((Object)value);
        }

        public String toString(DateTime value) {
            return ISODateTimeFormat.dateTime().print((ReadableInstant)value);
        }
    }

    public static class LocalDateTimeParamConverter
    implements ParamConverter<LocalDateTime> {
        public LocalDateTime fromString(String value) {
            return new LocalDateTime((Object)value);
        }

        public String toString(LocalDateTime value) {
            return ISODateTimeFormat.dateTime().print((ReadablePartial)value);
        }
    }

    public static class LocalTimeParamConverter
    implements ParamConverter<LocalTime> {
        public LocalTime fromString(String value) {
            return new LocalTime((Object)value);
        }

        public String toString(LocalTime value) {
            return ISODateTimeFormat.time().print((ReadablePartial)value);
        }
    }

    public static class LocalDateParamConverter
    implements ParamConverter<LocalDate> {
        public LocalDate fromString(String value) {
            return new LocalDate((Object)value);
        }

        public String toString(LocalDate value) {
            return ISODateTimeFormat.date().print((ReadablePartial)value);
        }
    }
}

