/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.joda.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;

@Provider
public class JodaParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (LocalDate.class.equals(rawType)) {
            return new LocalDateParamConverter<T>(rawType);
        }
        if (LocalTime.class.equals(rawType)) {
            return new LocalTimeParamConverter<T>(rawType);
        }
        if (LocalDateTime.class.equals(rawType)) {
            return new LocalDateTimeParamConverter<T>(rawType);
        }
        if (DateTime.class.equals(rawType)) {
            return new DateTimeParamConverter<T>(rawType);
        }
        return null;
    }

    public static class DateTimeParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        public DateTimeParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(new DateTime((Object)value));
        }

        public String toString(T value) {
            return ISODateTimeFormat.dateTime().print((ReadableInstant)((DateTime)value));
        }
    }

    public static class LocalDateTimeParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        public LocalDateTimeParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(new LocalDateTime((Object)value));
        }

        public String toString(T value) {
            return ISODateTimeFormat.dateTime().print((ReadablePartial)((LocalDateTime)value));
        }
    }

    public static class LocalTimeParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        public LocalTimeParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(new LocalTime((Object)value));
        }

        public String toString(T value) {
            return ISODateTimeFormat.time().print((ReadablePartial)((LocalTime)value));
        }
    }

    public static class LocalDateParamConverter<T>
    implements ParamConverter<T> {
        private final Class<T> rawType;

        public LocalDateParamConverter(Class<T> rawType) {
            this.rawType = rawType;
        }

        public T fromString(String value) {
            return value == null ? null : (T)this.rawType.cast(new LocalDate((Object)value));
        }

        public String toString(T value) {
            return ISODateTimeFormat.date().print((ReadablePartial)LocalDate.class.cast(value));
        }
    }
}

