/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.selenium;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.crazyyak.lib.selenium.WebElementReference;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class SeleniumBrowser {
    private final WebDriver driver;
    private long defaultTimeout;

    public SeleniumBrowser(WebDriver driver) throws Exception {
        this(driver, 500L, 10000L);
    }

    public SeleniumBrowser(WebDriver driver, long implicitlyWait, long defaultTimeout) throws Exception {
        this.defaultTimeout = defaultTimeout;
        this.driver = driver;
        this.driver.manage().timeouts().implicitlyWait(implicitlyWait, TimeUnit.MILLISECONDS);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public WebDriver.Window window() {
        return this.driver.manage().window();
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void quit() {
        this.driver.quit();
    }

    public void open(String url) {
        this.driver.get(url);
    }

    public void open(URL url) {
        this.driver.get(url.toExternalForm());
    }

    public void open(URI uri) throws MalformedURLException {
        this.driver.get(uri.toURL().toExternalForm());
    }

    public WebElementReference get(By by) {
        return new WebElementReference(this.driver, by, this.defaultTimeout);
    }

    public WebElementReference get(String key) {
        return new WebElementReference(this.driver, key, this.defaultTimeout);
    }

    public void acceptAlert() {
        Alert alert = this.driver.switchTo().alert();
        alert.accept();
    }

    public void dismissAlert() {
        Alert alert = this.driver.switchTo().alert();
        alert.dismiss();
    }
}

