/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Log4jServletContextListener
implements ServletContextListener {
    public static final String LOG4J_RELATIVE_PATH = "log4j-relative-path";
    public static final String LOG4J_PATTERN = "log4j-pattern";
    public static final String LOG4J_FILE_NAME = "log4j-file-name";
    public static final String LOG4J_LOG_LEVEL = "log4j-log-level";

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext context = sce.getServletContext();
            String logLevel = context.getInitParameter(LOG4J_LOG_LEVEL);
            Level level = logLevel == null ? Level.WARN : Level.toLevel((String)logLevel);
            Logger.getRootLogger().setLevel(level);
            String stndPattern = context.getInitParameter(LOG4J_PATTERN);
            String custPattern = context.getInitParameter(LOG4J_PATTERN);
            if (stndPattern == null) {
                stndPattern = "%-5p: %d{MM-dd-yy HH:mm:ss} [%t] %c %x- %m%n";
            }
            ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout(stndPattern));
            appender.setThreshold((Priority)Level.WARN);
            Logger.getRootLogger().addAppender((Appender)appender);
            if (custPattern == null) {
                custPattern = "%-5p: %d{MM-dd-yy HH:mm:ss} [%t] %c %x- %m%n";
            }
            appender = new ConsoleAppender((Layout)new PatternLayout(custPattern));
            appender.setThreshold((Priority)level);
            Logger.getLogger((String)"com.munchiemonster").addAppender((Appender)appender);
            Log log = LogFactory.getLog(Log4jServletContextListener.class);
            log.info((Object)("log4j initialized, standard pattern: " + stndPattern));
            log.info((Object)("log4j initialized, custom pattern: " + custPattern));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

