/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.servlet.template.tags;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.crazyyak.dev.common.StringUtils;

public class LanguageResourceTag
extends SimpleTagSupport {
    public static final String languageTagDefault = "language-tag-default";
    public static final String languageTagResourcePath = "language-tag-resource-path";
    private String key;

    public void doTag() throws JspException, IOException {
        try {
            Object path = this.getJspContext().findAttribute(languageTagResourcePath);
            if (path == null) {
                this.getJspContext().getOut().print("missing attribute language-tag-resource-path");
                return;
            }
            URL url = ((Object)((Object)this)).getClass().getResource(path.toString());
            if (url == null) {
                this.getJspContext().getOut().print("missing resource " + path);
                return;
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(url.toURI())));
            String propertyName = this.getLang() + "." + this.key;
            String value = properties.getProperty(propertyName);
            if (StringUtils.isNotBlank((Object)value)) {
                this.getJspContext().getOut().print(value);
            } else {
                this.getJspContext().getOut().print("missing key " + propertyName);
            }
        }
        catch (URISyntaxException e) {
            this.getJspContext().getOut().print(e.getMessage());
        }
    }

    public void setKey(String key) {
        this.key = key == null ? null : key.toLowerCase();
    }

    public String getLang() {
        Object defaultLang;
        PageContext pageContext;
        if (this.getJspContext() instanceof PageContext && (pageContext = (PageContext)this.getJspContext()).getRequest() instanceof HttpServletRequest) {
            Cookie[] cookies;
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            for (Cookie cookie : cookies = request.getCookies() == null ? new Cookie[]{} : request.getCookies()) {
                if (!cookie.getName().equals("lang")) continue;
                return cookie.getValue();
            }
        }
        return (defaultLang = this.getJspContext().findAttribute(languageTagDefault)) == null ? "en" : defaultLang.toString();
    }
}

