/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.lib.security.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.apis.google.users.GoogleAuthentication;
import org.crazyyak.apis.google.users.GoogleUsersUtils;
import org.crazyyak.apis.google.users.UserInfo;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.domain.account.CurrentUserSource;
import org.crazyyak.dev.domain.account.CurrentUserStore;
import org.crazyyak.lib.security.CurrentUser;
import org.crazyyak.lib.security.providers.ProviderUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class GooglePlusSecurityProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Log log = LogFactory.getLog(GooglePlusSecurityProvider.class);
    private final String clientSecret;
    private final String clientId;
    private final CurrentUserStore store;
    private final ObjectMapper objectMapper;

    public GooglePlusSecurityProvider(CurrentUserStore store, ObjectMapper objectMapper, String clientId, String clientSecret) {
        this.store = store;
        this.objectMapper = objectMapper;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (!ProviderUtils.isGoogleAuthentication(authentication) || userDetails == null) {
            throw new BadCredentialsException("Invalid user name or password");
        }
    }

    protected UserDetails retrieveUser(String userName, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            if (!ProviderUtils.isGoogleAuthentication(authentication)) {
                throw new UsernameNotFoundException("Not Goolge Authentication");
            }
            String code = authentication.getCredentials().toString();
            GoogleAuthentication googleAuth = GoogleUsersUtils.getAuthResponse((String)code, (String)this.clientId, (String)this.clientSecret);
            UserInfo userInfo = GoogleUsersUtils.getUserInfo((String)googleAuth.getAccessToken());
            CurrentUserSource source = this.store.getCurrentUserSourceByEmail(userInfo.getEmail());
            if (source == null) {
                throw new BadCredentialsException("Invalid user name or password");
            }
            return new CurrentUser(source);
        }
        catch (IOException e) {
            throw ApiException.internalServerError((String)"Exception during Google-Authentication", (Throwable)e, (String[])new String[0]);
        }
    }
}

