/*
 * Decompiled with CFR 0.152.
 */
package doodle.canvas.effect;

import cats.Eval;
import cats.Eval$;
import cats.FlatMap;
import cats.data.IndexedStateT;
import cats.effect.IO;
import cats.effect.IO$;
import doodle.algebra.Algebra;
import doodle.algebra.Picture;
import doodle.algebra.generic.Finalized;
import doodle.canvas.algebra.CanvasAlgebra;
import doodle.canvas.algebra.CanvasAlgebra$;
import doodle.canvas.algebra.CanvasDrawing$package$CanvasDrawing$;
import doodle.canvas.effect.Canvas$;
import doodle.canvas.effect.Frame;
import doodle.canvas.effect.Size;
import doodle.canvas.effect.Size$FitToPicture$;
import doodle.canvas.effect.Size$FixedSize$;
import doodle.core.BoundingBox;
import doodle.core.Color;
import doodle.core.Transform;
import doodle.core.Transform$;
import java.io.Serializable;
import org.scalajs.dom.CanvasRenderingContext2D;
import org.scalajs.dom.HTMLCanvasElement;
import org.scalajs.dom.Node;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;

public final class Canvas
implements Product,
Serializable {
    private final Node target;
    private final Frame frame;
    private final HTMLCanvasElement canvas;
    private final CanvasRenderingContext2D ctx;
    private final CanvasAlgebra algebra;

    public static Canvas apply(Node node, Frame frame) {
        return Canvas$.MODULE$.apply(node, frame);
    }

    public static IO<Canvas> fromFrame(Frame frame) {
        return Canvas$.MODULE$.fromFrame(frame);
    }

    public static Canvas fromProduct(Product product) {
        return Canvas$.MODULE$.fromProduct(product);
    }

    public static Canvas unapply(Canvas canvas) {
        return Canvas$.MODULE$.unapply(canvas);
    }

    public Canvas(Node target, Frame frame) {
        this.target = target;
        this.frame = frame;
        this.canvas = (HTMLCanvasElement)org.scalajs.dom.package$.MODULE$.document().createElement("canvas");
        this.ctx = (CanvasRenderingContext2D)this.canvas().getContext("2d", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[0]));
        this.algebra = CanvasAlgebra$.MODULE$.apply(this.ctx(), CanvasAlgebra$.MODULE$.$lessinit$greater$default$2(), CanvasAlgebra$.MODULE$.$lessinit$greater$default$3());
        target.appendChild((Node)this.canvas());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Canvas)) return false;
        Canvas canvas = (Canvas)object;
        Node node = this.target();
        Node node2 = canvas.target();
        if (node == null) {
            if (node2 != null) {
                return false;
            }
        } else if (!node.equals(node2)) return false;
        Frame frame = this.frame();
        Frame frame2 = canvas.frame();
        if (frame == null) {
            if (frame2 == null) return true;
            return false;
        } else {
            if (!((Object)frame).equals(frame2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Canvas;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Canvas";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "target";
        }
        if (1 == n2) {
            return "frame";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Node target() {
        return this.target;
    }

    public Frame frame() {
        return this.frame;
    }

    public HTMLCanvasElement canvas() {
        return this.canvas;
    }

    public CanvasRenderingContext2D ctx() {
        return this.ctx;
    }

    public CanvasAlgebra algebra() {
        return this.algebra;
    }

    public <A> IO<A> render(Picture<CanvasAlgebra, A> picture) {
        return IO$.MODULE$.apply(() -> this.render$$anonfun$1(picture));
    }

    public Canvas copy(Node target, Frame frame) {
        return new Canvas(target, frame);
    }

    public Node copy$default$1() {
        return this.target();
    }

    public Frame copy$default$2() {
        return this.frame();
    }

    public Node _1() {
        return this.target();
    }

    public Frame _2() {
        return this.frame();
    }

    private final /* synthetic */ void render$$anonfun$1$$anonfun$1(Color color) {
        this.ctx().fillStyle_$eq(Any$.MODULE$.fromString(CanvasDrawing$package$CanvasDrawing$.MODULE$.colorToCSS(color)));
        this.ctx().fillRect(0.0, 0.0, Int$.MODULE$.int2double(this.canvas().width()), Int$.MODULE$.int2double(this.canvas().height()));
    }

    private final Object render$$anonfun$1(Picture picture$1) {
        Transform transform;
        Finalized finalized = (Finalized)picture$1.apply((Algebra)this.algebra());
        Tuple2 tuple2 = (Tuple2)finalized.run(package$.MODULE$.List().empty()).value();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BoundingBox bb = (BoundingBox)tuple2._1();
        IndexedStateT rdr = (IndexedStateT)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)bb, (Object)rdr);
        BoundingBox bb2 = (BoundingBox)tuple22._1();
        IndexedStateT rdr2 = (IndexedStateT)tuple22._2();
        Size size = this.frame().size();
        if (size instanceof Size.FitToPicture) {
            int n;
            Size.FitToPicture fitToPicture = Size$FitToPicture$.MODULE$.unapply((Size.FitToPicture)size);
            int border = n = fitToPicture._1();
            double width = bb2.width() + (double)(2 * border);
            double height = bb2.height() + (double)(2 * border);
            double centerX = bb2.left() + bb2.width() / 2.0;
            double centerY = bb2.bottom() + bb2.height() / 2.0;
            this.canvas().setAttribute("width", BoxesRunTime.boxToDouble((double)width).toString());
            this.canvas().setAttribute("height", BoxesRunTime.boxToDouble((double)height).toString());
            transform = Transform$.MODULE$.translate(-centerX, -centerY).andThen(Transform$.MODULE$.logicalToScreen(width, height));
        } else if (size instanceof Size.FixedSize) {
            Size.FixedSize fixedSize = Size$FixedSize$.MODULE$.unapply((Size.FixedSize)size);
            double d = fixedSize._1();
            double d2 = fixedSize._2();
            double width = d;
            double height = d2;
            this.canvas().width_$eq((int)width);
            this.canvas().height_$eq((int)height);
            transform = Transform$.MODULE$.logicalToScreen(width, height);
        } else {
            throw new MatchError((Object)size);
        }
        Transform tx = transform;
        this.frame().background().foreach((Function1 & Serializable)color -> {
            this.render$$anonfun$1$$anonfun$1((Color)color);
            return BoxedUnit.UNIT;
        });
        Function1 drawing = (Function1)((Eval)rdr2.runA((Object)tx, (FlatMap)Eval$.MODULE$.catsBimonadForEval())).value();
        Object a = CanvasDrawing$package$CanvasDrawing$.MODULE$.apply(drawing, this.ctx());
        return a;
    }
}

