/*
 * Decompiled with CFR 0.152.
 */
package doodle.algebra;

import doodle.algebra.Path;
import doodle.algebra.Picture;
import doodle.core.Angle;
import doodle.core.ClosedPath;
import doodle.core.ClosedPath$;
import doodle.core.OpenPath;
import doodle.core.OpenPath$;
import doodle.core.Point;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public interface PathConstructor {
    public static Picture path$(PathConstructor $this, ClosedPath path) {
        return $this.path(path);
    }

    default public Picture<Path, BoxedUnit> path(ClosedPath path) {
        return new Picture<Path, BoxedUnit>(path){
            private final ClosedPath path$1;
            {
                this.path$1 = path$3;
            }

            public Object apply(Path algebra) {
                return algebra.path(this.path$1);
            }
        };
    }

    public static Picture path$(PathConstructor $this, OpenPath path) {
        return $this.path(path);
    }

    default public Picture<Path, BoxedUnit> path(OpenPath path) {
        return new Picture<Path, BoxedUnit>(path){
            private final OpenPath path$2;
            {
                this.path$2 = path$4;
            }

            public Object apply(Path algebra) {
                return algebra.path(this.path$2);
            }
        };
    }

    public static Picture arc$(PathConstructor $this, double diameter, Angle angle) {
        return $this.arc(diameter, angle);
    }

    default public Picture<Path, BoxedUnit> arc(double diameter, Angle angle) {
        return this.path(OpenPath$.MODULE$.arc(0.0, 0.0, diameter, angle));
    }

    public static Picture pie$(PathConstructor $this, double diameter, Angle angle) {
        return $this.pie(diameter, angle);
    }

    default public Picture<Path, BoxedUnit> pie(double diameter, Angle angle) {
        return this.path(ClosedPath$.MODULE$.pie(0.0, 0.0, diameter, angle));
    }

    public static Picture regularPolygon$(PathConstructor $this, int sides, double radius) {
        return $this.regularPolygon(sides, radius);
    }

    default public Picture<Path, BoxedUnit> regularPolygon(int sides, double radius) {
        return new Picture<Path, BoxedUnit>(sides, radius){
            private final int sides$1;
            private final double radius$1;
            {
                this.sides$1 = sides$2;
                this.radius$1 = radius$3;
            }

            public Object apply(Path algebra) {
                return algebra.regularPolygon(this.sides$1, this.radius$1);
            }
        };
    }

    public static Picture star$(PathConstructor $this, int points, double outerRadius, double innerRadius) {
        return $this.star(points, outerRadius, innerRadius);
    }

    default public Picture<Path, BoxedUnit> star(int points, double outerRadius, double innerRadius) {
        return new Picture<Path, BoxedUnit>(points, outerRadius, innerRadius){
            private final int points$1;
            private final double outerRadius$1;
            private final double innerRadius$1;
            {
                this.points$1 = points$4;
                this.outerRadius$1 = outerRadius$2;
                this.innerRadius$1 = innerRadius$2;
            }

            public Object apply(Path algebra) {
                return algebra.star(this.points$1, this.outerRadius$1, this.innerRadius$1);
            }
        };
    }

    public static Picture roundedRectangle$(PathConstructor $this, double width, double height, double radius) {
        return $this.roundedRectangle(width, height, radius);
    }

    default public Picture<Path, BoxedUnit> roundedRectangle(double width, double height, double radius) {
        return new Picture<Path, BoxedUnit>(width, height, radius){
            private final double width$1;
            private final double height$1;
            private final double radius$2;
            {
                this.width$1 = width$3;
                this.height$1 = height$2;
                this.radius$2 = radius$4;
            }

            public Object apply(Path algebra) {
                return algebra.roundedRectangle(this.width$1, this.height$1, this.radius$2);
            }
        };
    }

    public static Picture equilateralTriangle$(PathConstructor $this, double width) {
        return $this.equilateralTriangle(width);
    }

    default public Picture<Path, BoxedUnit> equilateralTriangle(double width) {
        return new Picture<Path, BoxedUnit>(width){
            private final double width$2;
            {
                this.width$2 = width$4;
            }

            public Object apply(Path algebra) {
                return algebra.equilateralTriangle(this.width$2);
            }
        };
    }

    public static Picture interpolatingSpline$(PathConstructor $this, Seq points) {
        return $this.interpolatingSpline((Seq<Point>)points);
    }

    default public Picture<Path, BoxedUnit> interpolatingSpline(Seq<Point> points) {
        return new Picture<Path, BoxedUnit>(points){
            private final Seq points$2;
            {
                this.points$2 = points$5;
            }

            public Object apply(Path algebra) {
                return algebra.interpolatingSpline((Seq<Point>)this.points$2);
            }
        };
    }

    public static Picture catmulRom$(PathConstructor $this, Seq points, double tension) {
        return $this.catmulRom((Seq<Point>)points, tension);
    }

    default public Picture<Path, BoxedUnit> catmulRom(Seq<Point> points, double tension) {
        return new Picture<Path, BoxedUnit>(points, tension){
            private final Seq points$3;
            private final double tension$1;
            {
                this.points$3 = points$6;
                this.tension$1 = tension$2;
            }

            public Object apply(Path algebra) {
                return algebra.catmulRom((Seq<Point>)this.points$3, this.tension$1);
            }
        };
    }

    public static double catmulRom$default$2$(PathConstructor $this) {
        return $this.catmulRom$default$2();
    }

    default public double catmulRom$default$2() {
        return 0.5;
    }
}

