/*
 * Decompiled with CFR 0.152.
 */
package doodle.syntax;

import doodle.algebra.Path;
import doodle.algebra.Picture;
import doodle.core.ClosedPath;
import doodle.core.OpenPath;
import doodle.core.Point;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public interface PathSyntax {
    public static ClosedPathOps ClosedPathOps$(PathSyntax $this, ClosedPath closedPath) {
        return $this.ClosedPathOps(closedPath);
    }

    default public ClosedPathOps ClosedPathOps(ClosedPath closedPath) {
        return new ClosedPathOps(this, closedPath);
    }

    public static OpenPathOps OpenPathOps$(PathSyntax $this, OpenPath openPath) {
        return $this.OpenPathOps(openPath);
    }

    default public OpenPathOps OpenPathOps(OpenPath openPath) {
        return new OpenPathOps(this, openPath);
    }

    public static Picture regularPolygon$(PathSyntax $this, int sides, double radius) {
        return $this.regularPolygon(sides, radius);
    }

    default public <Alg extends Path> Picture<Alg, BoxedUnit> regularPolygon(int sides, double radius) {
        return new Picture<Alg, BoxedUnit>(sides, radius){
            private final int sides$1;
            private final double radius$1;
            {
                this.sides$1 = sides$2;
                this.radius$1 = radius$3;
            }

            public Object apply(Path algebra) {
                return algebra.regularPolygon(this.sides$1, this.radius$1);
            }
        };
    }

    public static Picture star$(PathSyntax $this, int points, double outerRadius, double innerRadius) {
        return $this.star(points, outerRadius, innerRadius);
    }

    default public <Alg extends Path> Picture<Alg, BoxedUnit> star(int points, double outerRadius, double innerRadius) {
        return new Picture<Alg, BoxedUnit>(points, outerRadius, innerRadius){
            private final int points$1;
            private final double outerRadius$1;
            private final double innerRadius$1;
            {
                this.points$1 = points$4;
                this.outerRadius$1 = outerRadius$2;
                this.innerRadius$1 = innerRadius$2;
            }

            public Object apply(Path algebra) {
                return algebra.star(this.points$1, this.outerRadius$1, this.innerRadius$1);
            }
        };
    }

    public static Picture roundedRectangle$(PathSyntax $this, double width, double height, double radius) {
        return $this.roundedRectangle(width, height, radius);
    }

    default public <Alg extends Path> Picture<Alg, BoxedUnit> roundedRectangle(double width, double height, double radius) {
        return new Picture<Alg, BoxedUnit>(width, height, radius){
            private final double width$1;
            private final double height$1;
            private final double radius$2;
            {
                this.width$1 = width$3;
                this.height$1 = height$2;
                this.radius$2 = radius$4;
            }

            public Object apply(Path algebra) {
                return algebra.roundedRectangle(this.width$1, this.height$1, this.radius$2);
            }
        };
    }

    public static Picture equilateralTriangle$(PathSyntax $this, double width) {
        return $this.equilateralTriangle(width);
    }

    default public <Alg extends Path> Picture<Alg, BoxedUnit> equilateralTriangle(double width) {
        return new Picture<Alg, BoxedUnit>(width){
            private final double width$2;
            {
                this.width$2 = width$4;
            }

            public Object apply(Path algebra) {
                return algebra.equilateralTriangle(this.width$2);
            }
        };
    }

    public static Picture interpolatingSpline$(PathSyntax $this, Seq points) {
        return $this.interpolatingSpline((Seq<Point>)points);
    }

    default public <Alg extends Path> Picture<Alg, BoxedUnit> interpolatingSpline(Seq<Point> points) {
        return new Picture<Alg, BoxedUnit>(points){
            private final Seq points$2;
            {
                this.points$2 = points$5;
            }

            public Object apply(Path algebra) {
                return algebra.interpolatingSpline((Seq<Point>)this.points$2);
            }
        };
    }

    public static Picture catmulRom$(PathSyntax $this, Seq points, double tension) {
        return $this.catmulRom((Seq<Point>)points, tension);
    }

    default public <Alg extends Path> Picture<Alg, BoxedUnit> catmulRom(Seq<Point> points, double tension) {
        return new Picture<Alg, BoxedUnit>(points, tension){
            private final Seq points$3;
            private final double tension$1;
            {
                this.points$3 = points$6;
                this.tension$1 = tension$2;
            }

            public Object apply(Path algebra) {
                return algebra.catmulRom((Seq<Point>)this.points$3, this.tension$1);
            }
        };
    }

    public static double catmulRom$default$2$(PathSyntax $this) {
        return $this.catmulRom$default$2();
    }

    default public double catmulRom$default$2() {
        return 0.5;
    }

    public class ClosedPathOps {
        public final ClosedPath doodle$syntax$PathSyntax$ClosedPathOps$$closedPath;
        private final /* synthetic */ PathSyntax $outer;

        public ClosedPathOps(PathSyntax $outer, ClosedPath closedPath) {
            this.doodle$syntax$PathSyntax$ClosedPathOps$$closedPath = closedPath;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public <Alg extends Path> Picture<Alg, BoxedUnit> path() {
            return new Picture<Alg, BoxedUnit>(this){
                private final /* synthetic */ ClosedPathOps $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Object apply(Path algebra) {
                    return algebra.path(this.$outer.doodle$syntax$PathSyntax$ClosedPathOps$$closedPath);
                }
            };
        }

        public final /* synthetic */ PathSyntax doodle$syntax$PathSyntax$ClosedPathOps$$$outer() {
            return this.$outer;
        }
    }

    public class OpenPathOps {
        public final OpenPath doodle$syntax$PathSyntax$OpenPathOps$$openPath;
        private final /* synthetic */ PathSyntax $outer;

        public OpenPathOps(PathSyntax $outer, OpenPath openPath) {
            this.doodle$syntax$PathSyntax$OpenPathOps$$openPath = openPath;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public <Alg extends Path> Picture<Alg, BoxedUnit> path() {
            return new Picture<Alg, BoxedUnit>(this){
                private final /* synthetic */ OpenPathOps $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Object apply(Path algebra) {
                    return algebra.path(this.$outer.doodle$syntax$PathSyntax$OpenPathOps$$openPath);
                }
            };
        }

        public final /* synthetic */ PathSyntax doodle$syntax$PathSyntax$OpenPathOps$$$outer() {
            return this.$outer;
        }
    }
}

