/*
 * Decompiled with CFR 0.152.
 */
package doodle.image;

import cats.instances.package;
import cats.kernel.Semigroup;
import doodle.core.Angle;
import doodle.core.Angle$;
import doodle.core.ClosedPath;
import doodle.core.Color;
import doodle.core.OpenPath;
import doodle.core.PathElement;
import doodle.core.PathElement$;
import doodle.core.Point;
import doodle.core.Transform;
import doodle.image.Image;
import doodle.image.Image$Elements$Empty$;
import doodle.image.Path;
import doodle.language.Basic;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

public final class Image$
implements scala.Serializable {
    public static Image$ MODULE$;
    private final Image empty;
    private volatile byte bitmap$init$0;

    static {
        new Image$();
    }

    public Path closedPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.ClosedPath((List<PathElement>)((TraversableOnce)elements.$plus$colon((Object)pathElement, Seq$.MODULE$.canBuildFrom())).toList());
    }

    public Path openPath(Seq<PathElement> elements) {
        PathElement pathElement = PathElement$.MODULE$.moveTo(0.0, 0.0);
        return new Image.Elements.OpenPath((List<PathElement>)((TraversableOnce)elements.$plus$colon((Object)pathElement, Seq$.MODULE$.canBuildFrom())).toList());
    }

    public Image line(double x, double y) {
        double startX = -x / (double)2;
        double startY = -y / (double)2;
        double endX = x / (double)2;
        double endY = y / (double)2;
        return this.openPath((Seq<PathElement>)new .colon.colon((Object)PathElement$.MODULE$.moveTo(startX, startY), (List)new .colon.colon((Object)PathElement$.MODULE$.lineTo(endX, endY), (List)Nil$.MODULE$)));
    }

    public Image circle(double d) {
        return new Image.Elements.Circle(d);
    }

    public Image rectangle(double w, double h) {
        return new Image.Elements.Rectangle(w, h);
    }

    public Image square(double side) {
        return this.rectangle(side, side);
    }

    public Image regularPolygon(int sides, double radius, Angle angle) {
        Angle rotation = Angle$.MODULE$.one().$div((double)sides);
        List path = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), sides).map((Function1 & Serializable & scala.Serializable)n -> PathElement$.MODULE$.lineTo(radius, rotation.$times((double)BoxesRunTime.unboxToInt((Object)n)).$plus(angle)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        PathElement pathElement = PathElement$.MODULE$.moveTo(radius, angle);
        return this.closedPath((Seq<PathElement>)((Seq)path.$plus$colon((Object)pathElement, List$.MODULE$.canBuildFrom())));
    }

    public Image star(int points, double outerRadius, double innerRadius, Angle angle) {
        Angle rotation = Angle$.MODULE$.one().$div((double)points * 2.0);
        List path = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), points * 2).map((Function1 & Serializable & scala.Serializable)n -> Image$.$anonfun$star$1(outerRadius, rotation, angle, innerRadius, BoxesRunTime.unboxToInt((Object)n)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
        PathElement pathElement = PathElement$.MODULE$.moveTo(outerRadius, angle);
        return this.closedPath((Seq<PathElement>)((Seq)path.$plus$colon((Object)pathElement, List$.MODULE$.canBuildFrom())));
    }

    public Image rightArrow(double w, double h) {
        List path = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(w / (double)2, 0.0), PathElement$.MODULE$.lineTo(0.0, h / (double)2), PathElement$.MODULE$.lineTo(0.0, h * 0.2), PathElement$.MODULE$.lineTo(-w / (double)2, h * 0.2), PathElement$.MODULE$.lineTo(-w / (double)2, -h * 0.2), PathElement$.MODULE$.lineTo(0.0, -h * 0.2), PathElement$.MODULE$.lineTo(0.0, -h / (double)2), PathElement$.MODULE$.lineTo(w / (double)2, 0.0)}));
        return this.closedPath((Seq<PathElement>)path);
    }

    public Image roundedRectangle(double w, double h, double r) {
        double radius = r > w / (double)2 || r > h / (double)2 ? RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(w / (double)2), h / (double)2) : r;
        double c = 1.3333333333333333 * (Math.sqrt(2.0) - 1.0);
        double cR = c * radius;
        List elts = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PathElement[]{PathElement$.MODULE$.moveTo(w / (double)2 - radius, h / (double)2), PathElement$.MODULE$.curveTo(w / (double)2 - radius + cR, h / (double)2, w / (double)2, h / (double)2 - radius + cR, w / (double)2, h / (double)2 - radius), PathElement$.MODULE$.lineTo(w / (double)2, -h / (double)2 + radius), PathElement$.MODULE$.curveTo(w / (double)2, -h / (double)2 + radius - cR, w / (double)2 - radius + cR, -h / (double)2, w / (double)2 - radius, -h / (double)2), PathElement$.MODULE$.lineTo(-w / (double)2 + radius, -h / (double)2), PathElement$.MODULE$.curveTo(-w / (double)2 + radius - cR, -h / (double)2, -w / (double)2, -h / (double)2 + radius - cR, -w / (double)2, -h / (double)2 + radius), PathElement$.MODULE$.lineTo(-w / (double)2, h / (double)2 - radius), PathElement$.MODULE$.curveTo(-w / (double)2, h / (double)2 - radius + cR, -w / (double)2 + radius - cR, h / (double)2, -w / (double)2 + radius, h / (double)2), PathElement$.MODULE$.lineTo(w / (double)2 - radius, h / (double)2)}));
        return this.closedPath((Seq<PathElement>)elts);
    }

    public Image triangle(double w, double h) {
        return new Image.Elements.Triangle(w, h);
    }

    public Path interpolatingSpline(Seq<Point> points) {
        return this.catmulRom(points, this.catmulRom$default$2());
    }

    public Path catmulRom(Seq<Point> points, double tension) {
        return (Path)points.headOption().fold((Function0 & Serializable & scala.Serializable)() -> new Image.Elements.OpenPath((List<PathElement>)List$.MODULE$.empty()), (Function1 & Serializable & scala.Serializable)pt0 -> {
            PathElement pathElement = PathElement$.MODULE$.moveTo(pt0);
            Point point = pt0;
            return new Image.Elements.OpenPath((List<PathElement>)Image$.iter$1(points.toList().$colon$colon((Object)point), tension).$colon$colon((Object)pathElement));
        });
    }

    public double catmulRom$default$2() {
        return 0.5;
    }

    public Image empty() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/Image.scala: 355");
        }
        return this.empty;
    }

    public <Algebra extends Basic<?>, F> doodle.algebra.Image<Algebra, F, BoxedUnit> compile(Image image) {
        return doodle.algebra.Image$.MODULE$.apply((Function1 & Serializable & scala.Serializable)algebra -> {
            Object object;
            Image image = image;
            if (image instanceof Image.Elements.OpenPath) {
                Image.Elements.OpenPath openPath = (Image.Elements.OpenPath)image;
                List<PathElement> elements = openPath.elements();
                object = algebra.path(new OpenPath(elements.reverse()));
            } else if (image instanceof Image.Elements.ClosedPath) {
                Image.Elements.ClosedPath closedPath = (Image.Elements.ClosedPath)image;
                List<PathElement> elements = closedPath.elements();
                object = algebra.path(new ClosedPath(elements.reverse()));
            } else if (image instanceof Image.Elements.Circle) {
                Image.Elements.Circle circle = (Image.Elements.Circle)image;
                double d = circle.d();
                object = algebra.circle(d);
            } else if (image instanceof Image.Elements.Rectangle) {
                Image.Elements.Rectangle rectangle = (Image.Elements.Rectangle)image;
                double w = rectangle.w();
                double h = rectangle.h();
                object = algebra.rectangle(w, h);
            } else if (image instanceof Image.Elements.Triangle) {
                Image.Elements.Triangle triangle = (Image.Elements.Triangle)image;
                double w = triangle.w();
                double h = triangle.h();
                object = algebra.triangle(w, h);
            } else if (image instanceof Image.Elements.Beside) {
                Image.Elements.Beside beside = (Image.Elements.Beside)image;
                Image l = beside.l();
                Image r = beside.r();
                object = algebra.beside(MODULE$.compile(l).apply(algebra), MODULE$.compile(r).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
            } else if (image instanceof Image.Elements.Above) {
                Image.Elements.Above above = (Image.Elements.Above)image;
                Image l = above.l();
                Image r = above.r();
                object = algebra.above(MODULE$.compile(l).apply(algebra), MODULE$.compile(r).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
            } else if (image instanceof Image.Elements.On) {
                Image.Elements.On on = (Image.Elements.On)image;
                Image t = on.t();
                Image b = on.b();
                object = algebra.on(MODULE$.compile(t).apply(algebra), MODULE$.compile(b).apply(algebra), (Semigroup)package.unit$.MODULE$.catsKernelStdAlgebraForUnit());
            } else if (image instanceof Image.Elements.At) {
                Image.Elements.At at = (Image.Elements.At)image;
                Image image2 = at.image();
                double x = at.x();
                double y = at.y();
                object = algebra.at(MODULE$.compile(image2).apply(algebra), x, y);
            } else if (image instanceof Image.Elements.Transform) {
                Image.Elements.Transform transform = (Image.Elements.Transform)image;
                Transform tx = transform.tx();
                Image i = transform.i();
                object = algebra.transform(MODULE$.compile(i).apply(algebra), tx);
            } else if (image instanceof Image.Elements.StrokeWidth) {
                Image.Elements.StrokeWidth strokeWidth = (Image.Elements.StrokeWidth)image;
                Image image3 = strokeWidth.image();
                double width = strokeWidth.width();
                object = algebra.strokeWidth(MODULE$.compile(image3).apply(algebra), width);
            } else if (image instanceof Image.Elements.StrokeColor) {
                Image.Elements.StrokeColor strokeColor = (Image.Elements.StrokeColor)image;
                Image image4 = strokeColor.image();
                Color color = strokeColor.color();
                object = algebra.strokeColor(MODULE$.compile(image4).apply(algebra), color);
            } else if (image instanceof Image.Elements.FillColor) {
                Image.Elements.FillColor fillColor = (Image.Elements.FillColor)image;
                Image image5 = fillColor.image();
                Color color = fillColor.color();
                object = algebra.fillColor(MODULE$.compile(image5).apply(algebra), color);
            } else if (image instanceof Image.Elements.NoStroke) {
                Image.Elements.NoStroke noStroke = (Image.Elements.NoStroke)image;
                Image image6 = noStroke.image();
                object = algebra.noStroke(MODULE$.compile(image6).apply(algebra));
            } else if (image instanceof Image.Elements.NoFill) {
                Image.Elements.NoFill noFill = (Image.Elements.NoFill)image;
                Image image7 = noFill.image();
                object = algebra.noFill(MODULE$.compile(image7).apply(algebra));
            } else if (Image$Elements$Empty$.MODULE$.equals(image)) {
                object = algebra.empty();
            } else {
                throw new MatchError((Object)image);
            }
            return object;
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ PathElement $anonfun$star$1(double outerRadius$1, Angle rotation$2, Angle angle$2, double innerRadius$1, int n) {
        return n % 2 == 0 ? PathElement$.MODULE$.lineTo(outerRadius$1, rotation$2.$times((double)n).$plus(angle$2)) : PathElement$.MODULE$.lineTo(innerRadius$1, rotation$2.$times((double)n).$plus(angle$2));
    }

    private static final PathElement toCurve$1(Point pt0, Point pt1, Point pt2, Point pt3, double tension$1) {
        return PathElement$.MODULE$.curveTo((-tension$1 * pt0.x() + (double)3 * pt1.x() + tension$1 * pt2.x()) / 3.0, (-tension$1 * pt0.y() + (double)3 * pt1.y() + tension$1 * pt2.y()) / 3.0, (tension$1 * pt1.x() + (double)3 * pt2.x() - tension$1 * pt3.x()) / 3.0, (tension$1 * pt1.y() + (double)3 * pt2.y() - tension$1 * pt3.y()) / 3.0, pt2.x(), pt2.y());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final List iter$1(List points, double tension$1) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = points;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            Point pt0 = (Point)colon2.head();
            List list2 = colon2.tl$access$1();
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                Point pt1 = (Point)colon3.head();
                List list3 = colon3.tl$access$1();
                if (list3 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list3;
                    Point pt2 = (Point)colon4.head();
                    List list4 = colon4.tl$access$1();
                    if (list4 instanceof .colon.colon) {
                        .colon.colon colon5 = (.colon.colon)list4;
                        Point pt3 = (Point)colon5.head();
                        List pts = colon5.tl$access$1();
                        PathElement pathElement = Image$.toCurve$1(pt0, pt1, pt2, pt3, tension$1);
                        Point point = pt1;
                        Point point2 = pt2;
                        Point point3 = pt3;
                        return (List)Image$.iter$1((List)((List)((List)pts.$plus$colon((Object)point3, List$.MODULE$.canBuildFrom())).$plus$colon((Object)point2, List$.MODULE$.canBuildFrom())).$plus$colon((Object)point, List$.MODULE$.canBuildFrom()), tension$1).$plus$colon((Object)pathElement, List$.MODULE$.canBuildFrom());
                    }
                }
            }
        }
        if (!bl) return List$.MODULE$.empty();
        Point pt0 = (Point)colon2.head();
        List list5 = colon2.tl$access$1();
        if (!(list5 instanceof .colon.colon)) return List$.MODULE$.empty();
        .colon.colon colon6 = (.colon.colon)list5;
        Point pt1 = (Point)colon6.head();
        List list6 = colon6.tl$access$1();
        if (!(list6 instanceof .colon.colon)) return List$.MODULE$.empty();
        .colon.colon colon7 = (.colon.colon)list6;
        Point pt2 = (Point)colon7.head();
        List list7 = colon7.tl$access$1();
        Some some = Seq$.MODULE$.unapplySeq((Seq)list7);
        if (some.isEmpty()) return List$.MODULE$.empty();
        if (some.get() == null) return List$.MODULE$.empty();
        if (((SeqLike)some.get()).lengthCompare(0) != 0) return List$.MODULE$.empty();
        Point pt3 = pt2;
        return new .colon.colon((Object)Image$.toCurve$1(pt0, pt1, pt2, pt3, tension$1), (List)Nil$.MODULE$);
    }

    private Image$() {
        MODULE$ = this;
        this.empty = Image$Elements$Empty$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

