/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import doodle.core.Color;
import doodle.core.Color$;
import doodle.image.Image;
import doodle.image.examples.Complex;
import doodle.image.examples.Mandelbrot;
import doodle.syntax.package;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;

public final class Mandelbrot$ {
    public static Mandelbrot$ MODULE$;
    private final int maxApplys;
    private final List<Color> defaultPalette;
    private final Mandelbrot.PaletteCellRenderer defaultRenderer;
    private final Image image;
    private volatile byte bitmap$init$0;

    static {
        new Mandelbrot$();
    }

    public int maxApplys() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Mandelbrot.scala: 39");
        }
        return this.maxApplys;
    }

    public List<Color> defaultPalette() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Mandelbrot.scala: 62");
        }
        return this.defaultPalette;
    }

    public Mandelbrot.PaletteCellRenderer defaultRenderer() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Mandelbrot.scala: 65");
        }
        return this.defaultRenderer;
    }

    public int countUntilDiverges(Complex z, Function1<Complex, Complex> func) {
        LazyRef series$lzy = new LazyRef();
        return Mandelbrot$.series$1(series$lzy, z, func).takeWhile((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.closeTo(z, x$4.closeTo$default$2()))).take(this.maxApplys()).length();
    }

    public Image cell(Complex center, int size, Mandelbrot.CellRenderer renderer) {
        int count = this.countUntilDiverges(center, (Function1<Complex, Complex>)(Function1 & java.io.Serializable & Serializable)z -> z.$times((Complex)z).$plus(center));
        return renderer.apply(size, count);
    }

    public Image mandlebrot(Complex fractalCenter, Complex domainSize, int displaySize, Mandelbrot.CellRenderer renderer, int minSize) {
        Image image;
        if (displaySize <= minSize) {
            image = this.cell(fractalCenter, displaySize, renderer);
        } else {
            int cellDisplaySize = displaySize / 2;
            Complex cellDomainSize = domainSize.$div(2.0);
            double quarterWidth = domainSize.real() / (double)4;
            double quarterHeight = domainSize.imaginary() / (double)4;
            double centerX = fractalCenter.real();
            double centerY = fractalCenter.imaginary();
            Image topLeft = this.mandlebrot(new Complex(centerX - quarterWidth, centerY + quarterHeight), cellDomainSize, cellDisplaySize, renderer, this.mandlebrot$default$5());
            Image topRight = this.mandlebrot(new Complex(centerX + quarterWidth, centerY + quarterHeight), cellDomainSize, cellDisplaySize, renderer, this.mandlebrot$default$5());
            Image bottomLeft = this.mandlebrot(new Complex(centerX - quarterWidth, centerY - quarterHeight), cellDomainSize, cellDisplaySize, renderer, this.mandlebrot$default$5());
            Image bottomRight = this.mandlebrot(new Complex(centerX + quarterWidth, centerY - quarterHeight), domainSize.$div(2.0), cellDisplaySize, renderer, this.mandlebrot$default$5());
            image = topLeft.beside(topRight).above(bottomLeft.beside(bottomRight));
        }
        return image;
    }

    public Mandelbrot.CellRenderer mandlebrot$default$4() {
        return this.defaultRenderer();
    }

    public int mandlebrot$default$5() {
        return 4;
    }

    public Image image() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Mandelbrot.scala: 120");
        }
        return this.image;
    }

    private static final /* synthetic */ Stream series$lzycompute$1(LazyRef series$lzy$1, Complex z$1, Function1 func$1) {
        Stream stream;
        LazyRef lazyRef = series$lzy$1;
        synchronized (lazyRef) {
            Stream stream2;
            if (series$lzy$1.initialized()) {
                stream2 = (Stream)series$lzy$1.value();
            } else {
                Complex complex = z$1;
                stream2 = (Stream)series$lzy$1.initialize((Object)Stream$.MODULE$.consWrapper((Function0 & java.io.Serializable & Serializable)() -> (Stream)Mandelbrot$.series$1(series$lzy$1, z$1, func$1).map((Function1 & java.io.Serializable & Serializable)x$2 -> (Complex)func$1.apply(x$2), Stream$.MODULE$.canBuildFrom())).$hash$colon$colon((Object)complex));
            }
            stream = stream2;
        }
        return stream;
    }

    private static final Stream series$1(LazyRef series$lzy$1, Complex z$1, Function1 func$1) {
        return series$lzy$1.initialized() ? (Stream)series$lzy$1.value() : Mandelbrot$.series$lzycompute$1(series$lzy$1, z$1, func$1);
    }

    private Mandelbrot$() {
        MODULE$ = this;
        this.maxApplys = 50;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        Color color = Color$.MODULE$.black();
        this.defaultPalette = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 360).by(5).map((Function1 & java.io.Serializable & Serializable)angle -> Color$.MODULE$.hsl(package.angle$.MODULE$.AngleIntOps(BoxesRunTime.unboxToInt((Object)angle)).degrees(), 1.0, 0.4), IndexedSeq$.MODULE$.canBuildFrom())).toList().$colon$colon((Object)color);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.defaultRenderer = new Mandelbrot.PaletteCellRenderer(this.defaultPalette());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.image = this.mandlebrot(new Complex(-0.5, 0.0), new Complex(3.0, 3.0), 512, this.mandlebrot$default$4(), this.mandlebrot$default$5());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

