/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import cats.Foldable;
import cats.Traverse;
import cats.free.Free;
import cats.free.Free$;
import cats.implicits$;
import doodle.core.Angle;
import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Parametric;
import doodle.core.Parametric$;
import doodle.core.PathElement;
import doodle.core.PathElement$;
import doodle.core.Point;
import doodle.core.Point$;
import doodle.core.Vec;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.image.syntax.package$;
import doodle.image.syntax.package$core$;
import doodle.random;
import doodle.random$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Sine$ {
    public static Sine$ MODULE$;
    private final Color underBlue;
    private final Free<random.RandomOp, Angle> randomAngle;
    private final Free<random.RandomOp, List<Point>> samples;
    private final Image spacer;
    private final Image sines;
    private final List<Image> images;
    private volatile byte bitmap$init$0;

    static {
        new Sine$();
    }

    public Color underBlue() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Sine.scala: 17");
        }
        return this.underBlue;
    }

    public Parametric.AngularCurve sine(int width, double amplitude, int period) {
        double frequency = (double)width / (double)period;
        return new Parametric.AngularCurve(Parametric$.MODULE$.sine(amplitude, frequency).andThen((Function1 & Serializable & scala.Serializable)pt -> Point$.MODULE$.apply((pt.x() - 0.5) * (double)width, pt.y())));
    }

    public Function1<Angle, Free<random.RandomOp, Point>> noisySine(Parametric.AngularCurve curve, double stdDev) {
        return (Function1 & Serializable & scala.Serializable)angle -> random.Random$.MODULE$.normal(0.0, stdDev).map((Function1 & Serializable & scala.Serializable)offset -> Sine$.$anonfun$noisySine$2(curve, angle, BoxesRunTime.unboxToDouble((Object)offset)));
    }

    public double noisySine$default$2() {
        return 15.0;
    }

    public Free<random.RandomOp, Angle> randomAngle() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Sine.scala: 34");
        }
        return this.randomAngle;
    }

    public Free<random.RandomOp, List<Point>> noiseSamples(int n, Function1<Angle, Free<random.RandomOp, Point>> f) {
        return (Free)implicits$.MODULE$.toFoldableOps((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).toList(), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).foldM((Object)List$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(accum, x$1) -> Sine$.$anonfun$noiseSamples$1(f, accum, BoxesRunTime.unboxToInt((Object)x$1)), Free$.MODULE$.catsFreeMonadForFree());
    }

    public Free<random.RandomOp, List<Point>> samples() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Sine.scala: 41");
        }
        return this.samples;
    }

    public double error(Parametric.AngularCurve curve, List<Point> data) {
        return BoxesRunTime.unboxToDouble((Object)data.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(error, pt) -> BoxesRunTime.boxToDouble((double)Sine$.$anonfun$error$1(curve, BoxesRunTime.unboxToDouble((Object)error), pt))));
    }

    public Image errorPlot(List<Point> data, List<Object> periods) {
        List errors = (List)((List)periods.sorted(implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForInt()))).map((Function1 & Serializable & scala.Serializable)p -> Point$.MODULE$.apply((double)BoxesRunTime.unboxToInt((Object)p), Sine$.MODULE$.error(Sine$.MODULE$.sine(2000, 150.0, BoxesRunTime.unboxToInt((Object)p)), (List<Point>)data)), List$.MODULE$.canBuildFrom());
        int maxPeriod = BoxesRunTime.unboxToInt((Object)periods.max(implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForInt())));
        double max = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)errors.map((Function1 & Serializable & scala.Serializable)pt -> BoxesRunTime.boxToDouble((double)pt.y()), List$.MODULE$.canBuildFrom())).max(implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForDouble())));
        List scaled = (List)errors.map((Function1 & Serializable & scala.Serializable)pt -> Point$.MODULE$.apply(pt.x(), pt.y() * (double)maxPeriod * 0.5625 / max), List$.MODULE$.canBuildFrom());
        Image points = package$.MODULE$.TraverseImageOps(scaled.map((Function1 & Serializable & scala.Serializable)pt -> Image$.MODULE$.circle(13.0).at(pt.toVec()).fillColor(Color$.MODULE$.white()).noStroke(), List$.MODULE$.canBuildFrom())).allOn((Traverse<Object>)implicits$.MODULE$.catsStdInstancesForList());
        Image curve = Image$.MODULE$.interpolatingSpline((Seq<Point>)scaled).strokeWidth(11.0).strokeColor(Color$.MODULE$.white());
        return points.on(curve);
    }

    public Image gradientDescent(List<Point> data, List<Object> periods, int start, int goal, int step) {
        List visited;
        List steps = (List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)goal), (Object)BoxesRunTime.boxToInteger((int)step), (Integral)Numeric.IntIsIntegral$.MODULE$);
        List errors = (List)((List)periods.sorted(implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForInt()))).map((Function1 & Serializable & scala.Serializable)p -> Point$.MODULE$.apply((double)BoxesRunTime.unboxToInt((Object)p), Sine$.MODULE$.error(Sine$.MODULE$.sine(2000, 150.0, BoxesRunTime.unboxToInt((Object)p)), (List<Point>)data)), List$.MODULE$.canBuildFrom());
        int maxPeriod = BoxesRunTime.unboxToInt((Object)periods.max(implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForInt())));
        double max = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)errors.map((Function1 & Serializable & scala.Serializable)pt -> BoxesRunTime.boxToDouble((double)pt.y()), List$.MODULE$.canBuildFrom())).max(implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForDouble())));
        List scaled = (List)errors.map((Function1 & Serializable & scala.Serializable)pt -> Point$.MODULE$.apply(pt.x(), pt.y() * (double)maxPeriod * 0.5625 / max), List$.MODULE$.canBuildFrom());
        Image curve = Image$.MODULE$.interpolatingSpline((Seq<Point>)scaled).strokeWidth(11.0).strokeColor(Color$.MODULE$.white());
        Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)((List)((List)steps.map((Function1 & Serializable & scala.Serializable)p -> Point$.MODULE$.apply((double)BoxesRunTime.unboxToInt((Object)p), Sine$.MODULE$.error(Sine$.MODULE$.sine(2000, 150.0, BoxesRunTime.unboxToInt((Object)p)), (List<Point>)data)), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)pt -> Point$.MODULE$.apply(pt.x(), pt.y() * (double)maxPeriod * 0.5625 / max), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)pt -> Image$.MODULE$.circle(13.0).at(pt.toVec()).noStroke(), List$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(accum, img) -> {
            Tuple2 tuple2 = accum;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double lightness = tuple2._1$mcD$sp();
            List soFar = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)lightness), (Object)soFar);
            Tuple2 tuple23 = tuple22;
            double lightness2 = tuple23._1$mcD$sp();
            List soFar2 = (List)tuple23._2();
            Image image = img.fillColor(Color$.MODULE$.red().lightness(package$core$.MODULE$.ToNormalizedOps(lightness2).normalized()));
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)(lightness2 * 0.9)), (Object)soFar2.$colon$colon((Object)image));
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List list = visited = (List)tuple2._2();
        List visited2 = list;
        return package$.MODULE$.TraverseImageOps(visited2).allOn((Traverse<List>)implicits$.MODULE$.catsStdInstancesForList()).on(curve);
    }

    public Image errorBars(List<Point> data, Parametric.AngularCurve curve, int width) {
        return package$.MODULE$.TraverseImageOps(data.map((Function1 & Serializable & scala.Serializable)pt -> {
            Angle angle = package$core$.MODULE$.AngleDoubleOps((pt.x() + (double)(width / 2)) / (double)width).turns();
            Point predicted = curve.apply(angle);
            return Image$.MODULE$.openPath((Seq<PathElement>)new .colon.colon((Object)PathElement$.MODULE$.moveTo(pt.x(), pt.y()), (List)new .colon.colon((Object)PathElement$.MODULE$.lineTo(predicted.x(), predicted.y()), (List)Nil$.MODULE$))).strokeColor(MODULE$.underBlue()).strokeWidth(7.0);
        }, List$.MODULE$.canBuildFrom())).allOn((Traverse<Object>)implicits$.MODULE$.catsStdInstancesForList());
    }

    public Image styledSine(Parametric.AngularCurve curve) {
        return Image$.MODULE$.interpolatingSpline((Seq<Point>)curve.sample(200)).strokeWidth(11.0).strokeColor(Color$.MODULE$.white());
    }

    public Image spacer() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Sine.scala: 122");
        }
        return this.spacer;
    }

    public Image sines() {
        if ((byte)(this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Sine.scala: 124");
        }
        return this.sines;
    }

    public List<Image> images() {
        if ((byte)(this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/noel/dev/doodle/code/image/shared/src/main/scala/doodle/image/examples/Sine.scala: 138");
        }
        return this.images;
    }

    public static final /* synthetic */ Point $anonfun$noisySine$2(Parametric.AngularCurve curve$1, Angle angle$1, double offset) {
        return curve$1.apply(angle$1).$plus(new Vec(0.0, offset));
    }

    public static final /* synthetic */ Angle $anonfun$randomAngle$1(double a) {
        return package$core$.MODULE$.AngleDoubleOps(a).turns();
    }

    public static final /* synthetic */ Free $anonfun$noiseSamples$1(Function1 f$1, List accum, int x$1) {
        return MODULE$.randomAngle().flatMap(f$1).map((Function1 & Serializable & scala.Serializable)pt -> {
            Point point = pt;
            return accum.$colon$colon((Object)point);
        });
    }

    public static final /* synthetic */ double $anonfun$error$1(Parametric.AngularCurve curve$2, double error, Point pt) {
        double diff = curve$2.apply(package$core$.MODULE$.AngleDoubleOps((pt.x() + 1000.0) / 2000.0).turns()).y() - pt.y();
        return error + diff * diff;
    }

    public static final /* synthetic */ Image $anonfun$images$3(int p) {
        return MODULE$.styledSine(MODULE$.sine(2000, 150.0, p)).on(MODULE$.spacer());
    }

    private Sine$() {
        MODULE$ = this;
        this.underBlue = Color$.MODULE$.rgb(package$core$.MODULE$.ToUnsignedByteOps(39).uByte(), package$core$.MODULE$.ToUnsignedByteOps(170).uByte(), package$core$.MODULE$.ToUnsignedByteOps(255).uByte());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.randomAngle = random.Random$.MODULE$.double().map((Function1 & Serializable & scala.Serializable)a -> Sine$.$anonfun$randomAngle$1(BoxesRunTime.unboxToDouble((Object)a)));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.samples = this.noiseSamples(100, this.noisySine(this.sine(2000, 150.0, 400), this.noisySine$default$2()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.spacer = Image$.MODULE$.rectangle(2000.0, 500.0).noStroke().noFill();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        Image s1 = Image$.MODULE$.interpolatingSpline((Seq<Point>)this.sine(2000, 150.0, 200).sample(200)).strokeWidth(11.0);
        Image s2 = Image$.MODULE$.interpolatingSpline((Seq<Point>)this.sine(2000, 150.0, 400).sample(200)).strokeWidth(11.0);
        Image s3 = Image$.MODULE$.interpolatingSpline((Seq<Point>)this.sine(2000, 150.0, 800).sample(200)).strokeWidth(11.0);
        Color c1 = this.underBlue().lightness(package$core$.MODULE$.ToNormalizedOps(0.8).normalized());
        Color.HSLA c3 = c1.spin(package$core$.MODULE$.AngleIntOps(180).degrees());
        this.sines = s2.strokeColor(Color$.MODULE$.white()).on(s1.strokeColor(c1)).on(s3.strokeColor((Color)c3));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.images = (List)this.samples().map((Function1 & Serializable & scala.Serializable)data -> {
            Image descent;
            List periods = (List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)100), (Object)BoxesRunTime.boxToInteger((int)1625), (Object)BoxesRunTime.boxToInteger((int)25), (Integral)Numeric.IntIsIntegral$.MODULE$);
            Image dataPlot = package$.MODULE$.TraverseImageOps(data.map((Function1 & Serializable & scala.Serializable)pt -> Image$.MODULE$.circle(9.0).at(pt.toVec()), List$.MODULE$.canBuildFrom())).allOn((Traverse<Object>)implicits$.MODULE$.catsStdInstancesForList()).fillColor(MODULE$.underBlue()).noStroke();
            List sines = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 200, 400, 800, 1600})).map((Function1 & Serializable & scala.Serializable)p -> Sine$.$anonfun$images$3(BoxesRunTime.unboxToInt((Object)p)), List$.MODULE$.canBuildFrom());
            Image bars = MODULE$.errorBars((List<Point>)data, MODULE$.sine(2000, 150.0, 1600), 2000);
            Image squaredError = MODULE$.errorPlot((List<Point>)data, (List<Object>)periods);
            Image image = descent = MODULE$.gradientDescent((List<Point>)data, (List<Object>)periods, 350, 410, 10);
            Image image2 = squaredError;
            Image image3 = dataPlot.on(MODULE$.spacer());
            Image image4 = ((Image)sines.last()).on(dataPlot).on(bars);
            return ((List)sines.map((Function1 & Serializable & scala.Serializable)s -> dataPlot.on((Image)s), List$.MODULE$.canBuildFrom())).$colon$colon((Object)image4).$colon$colon((Object)image3).$colon$colon((Object)image2).$colon$colon((Object)image);
        }).run(random$.MODULE$.randomInstances(random$.MODULE$.randomInstances$default$1()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
    }
}

