/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import doodle.core.Color;
import doodle.core.Color$;
import doodle.core.Normalized;
import doodle.image.Image;
import doodle.image.Image$;
import doodle.syntax.package;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;

public final class ColorPaletteAgain$ {
    public static final ColorPaletteAgain$ MODULE$ = new ColorPaletteAgain$();
    private static final double circleMinimum = 50.0;
    private static final double circleIncrement;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        circleIncrement = 10.0;
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    public double circleMinimum() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/noel/dev/creativescala/doodle/image/shared/src/main/scala/doodle/image/examples/ColorPaletteAgain.scala: 10");
        }
        return circleMinimum;
    }

    public double circleIncrement() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/noel/dev/creativescala/doodle/image/shared/src/main/scala/doodle/image/examples/ColorPaletteAgain.scala: 11");
        }
        return circleIncrement;
    }

    public Color complement(Color c) {
        return c.spin(package.all$.MODULE$.AngleIntOps(180).degrees());
    }

    public Color nearComplement(Color c) {
        return c.spin(package.all$.MODULE$.AngleIntOps(170).degrees());
    }

    public Color analogous(Color c) {
        return c.spin(package.all$.MODULE$.AngleIntOps(15).degrees());
    }

    public Image singleCircle(int n, Color color) {
        return Image$.MODULE$.circle(this.circleMinimum() + this.circleIncrement() * (double)n).strokeColor(color).strokeWidth(this.circleIncrement());
    }

    public Image complementCircles(int n, Color c) {
        Color color = this.complement(c);
        return n == 1 ? this.singleCircle(n, color) : this.complementCircles(n - 1, color).on(this.singleCircle(n, color));
    }

    public Image nearComplementCircles(int n, Color c) {
        Color color = this.nearComplement(c);
        return n == 1 ? this.singleCircle(n, color) : this.nearComplementCircles(n - 1, color).on(this.singleCircle(n, color));
    }

    public Image coloredCircles(int n, Color c, Function1<Color, Color> palette) {
        Color color = (Color)palette.apply((Object)c);
        return n == 1 ? this.singleCircle(n, color) : this.coloredCircles(n - 1, color, palette).on(this.singleCircle(n, color));
    }

    public int lcg1(int input) {
        int a = 8121;
        int c = 28411;
        int m = 134456;
        return (a * input + c) % m;
    }

    public int lcg2(int input) {
        int a = 48271;
        int m = Integer.MAX_VALUE;
        int q = m / a;
        int r = m % a;
        int result = a * (input % q) - r * (input / q);
        return result <= 0 ? result + m : result;
    }

    public double normalize(int value, int max) {
        return package.all$.MODULE$.ToNormalizedOps((double)value / (double)max).normalized();
    }

    public double rescale(double value, double min, double range) {
        return package.all$.MODULE$.ToNormalizedOps(value * range + min).normalized();
    }

    public Color lcgColor(Color c) {
        Color.HSLA spun = c.spin(package.all$.MODULE$.AngleIntOps(169).degrees());
        double saturation = this.rescale(this.normalize(this.lcg1((int)spun.hue().toDegrees()), 134456), 0.25, 0.75);
        double lightness = this.rescale(this.normalize(this.lcg2((int)spun.hue().toDegrees()), Integer.MAX_VALUE), 0.25, 0.5);
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("saturation ").append(new Normalized(saturation)).append(" lightness ").append(new Normalized(lightness)).toString());
        return spun.saturation(saturation).lightness(lightness);
    }

    public Image image() {
        return this.complementCircles(10, Color$.MODULE$.seaGreen()).beside(this.nearComplementCircles(10, Color$.MODULE$.seaGreen())).beside(this.coloredCircles(10, Color$.MODULE$.seaGreen(), (Function1<Color, Color>)(Function1 & Serializable)c -> MODULE$.lcgColor((Color)c)));
    }

    private ColorPaletteAgain$() {
    }
}

