/*
 * Decompiled with CFR 0.152.
 */
package doodle.image.examples;

import doodle.core.Color;
import doodle.core.Color$;
import doodle.image.Image;
import doodle.image.examples.Complex;
import doodle.image.examples.Mandelbrot;
import doodle.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;

public final class Mandelbrot$ {
    public static final Mandelbrot$ MODULE$ = new Mandelbrot$();
    private static final int maxApplys = 50;
    private static final List<Color> defaultPalette;
    private static final Mandelbrot.PaletteCellRenderer defaultRenderer;
    private static final Image image;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        Color color = Color$.MODULE$.black();
        defaultPalette = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 360).by(5).map((Function1 & Serializable)angle -> Color$.MODULE$.hsl(package.angle$.MODULE$.AngleIntOps(BoxesRunTime.unboxToInt((Object)angle)).degrees(), 1.0, 0.4)).toList().$colon$colon((Object)color);
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        defaultRenderer = new Mandelbrot.PaletteCellRenderer(MODULE$.defaultPalette());
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        image = MODULE$.mandlebrot(new Complex(-0.5, 0.0), new Complex(3.0, 3.0), 512, MODULE$.mandlebrot$default$4(), MODULE$.mandlebrot$default$5());
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    public int maxApplys() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/noel/dev/creativescala/doodle/image/shared/src/main/scala-2.13/doodle/image/examples/Mandelbrot.scala: 41");
        }
        return maxApplys;
    }

    public List<Color> defaultPalette() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/noel/dev/creativescala/doodle/image/shared/src/main/scala-2.13/doodle/image/examples/Mandelbrot.scala: 64");
        }
        return defaultPalette;
    }

    public Mandelbrot.PaletteCellRenderer defaultRenderer() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/noel/dev/creativescala/doodle/image/shared/src/main/scala-2.13/doodle/image/examples/Mandelbrot.scala: 67");
        }
        return defaultRenderer;
    }

    public int countUntilDiverges(Complex z, Function1<Complex, Complex> func) {
        LazyRef series$lzy = new LazyRef();
        return Mandelbrot$.series$1(series$lzy, func, z).takeWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.closeTo(z, x$2.closeTo$default$2()))).take(this.maxApplys()).length();
    }

    public Image cell(Complex center, int size, Mandelbrot.CellRenderer renderer) {
        int count = this.countUntilDiverges(center, (Function1<Complex, Complex>)(Function1 & Serializable)z -> z.$times((Complex)z).$plus(center));
        return renderer.apply(size, count);
    }

    public Image mandlebrot(Complex fractalCenter, Complex domainSize, int displaySize, Mandelbrot.CellRenderer renderer, int minSize) {
        Image image;
        if (displaySize <= minSize) {
            image = this.cell(fractalCenter, displaySize, renderer);
        } else {
            int cellDisplaySize = displaySize / 2;
            Complex cellDomainSize = domainSize.$div(2.0);
            double quarterWidth = domainSize.real() / (double)4;
            double quarterHeight = domainSize.imaginary() / (double)4;
            double centerX = fractalCenter.real();
            double centerY = fractalCenter.imaginary();
            Image topLeft = this.mandlebrot(new Complex(centerX - quarterWidth, centerY + quarterHeight), cellDomainSize, cellDisplaySize, renderer, this.mandlebrot$default$5());
            Image topRight = this.mandlebrot(new Complex(centerX + quarterWidth, centerY + quarterHeight), cellDomainSize, cellDisplaySize, renderer, this.mandlebrot$default$5());
            Image bottomLeft = this.mandlebrot(new Complex(centerX - quarterWidth, centerY - quarterHeight), cellDomainSize, cellDisplaySize, renderer, this.mandlebrot$default$5());
            Image bottomRight = this.mandlebrot(new Complex(centerX + quarterWidth, centerY - quarterHeight), domainSize.$div(2.0), cellDisplaySize, renderer, this.mandlebrot$default$5());
            image = topLeft.beside(topRight).above(bottomLeft.beside(bottomRight));
        }
        return image;
    }

    public Mandelbrot.CellRenderer mandlebrot$default$4() {
        return this.defaultRenderer();
    }

    public int mandlebrot$default$5() {
        return 4;
    }

    public Image image() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/noel/dev/creativescala/doodle/image/shared/src/main/scala-2.13/doodle/image/examples/Mandelbrot.scala: 124");
        }
        return image;
    }

    private static final /* synthetic */ LazyList series$lzycompute$1(LazyRef series$lzy$1, Function1 func$1, Complex z$1) {
        LazyList lazyList;
        LazyRef lazyRef = series$lzy$1;
        synchronized (lazyRef) {
            lazyList = series$lzy$1.initialized() ? (LazyList)series$lzy$1.value() : (LazyList)series$lzy$1.initialize((Object)LazyList.Deferrer$.MODULE$.$hash$colon$colon$extension(LazyList$.MODULE$.toDeferrer((Function0 & Serializable)() -> Mandelbrot$.series$1(series$lzy$1, func$1, z$1).map((Function1 & Serializable)x$1 -> (Complex)func$1.apply(x$1))), (Function0 & Serializable)() -> z$1));
        }
        return lazyList;
    }

    private static final LazyList series$1(LazyRef series$lzy$1, Function1 func$1, Complex z$1) {
        return series$lzy$1.initialized() ? (LazyList)series$lzy$1.value() : Mandelbrot$.series$lzycompute$1(series$lzy$1, func$1, z$1);
    }

    private Mandelbrot$() {
    }
}

